/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.httppanel.view.impl.models.http.response;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.zaproxy.zap.extension.httppanel.InvalidMessageDataException;
import org.zaproxy.zap.extension.httppanel.view.impl.models.http.AbstractHttpStringHttpPanelViewModel;

public class ResponseStringHttpPanelViewModel
extends AbstractHttpStringHttpPanelViewModel {
    private static final Logger LOGGER = LogManager.getLogger(ResponseStringHttpPanelViewModel.class);

    @Override
    public String getData() {
        if (this.httpMessage == null || this.httpMessage.getResponseHeader().isEmpty()) {
            return "";
        }
        return this.httpMessage.getResponseHeader().toString().replaceAll("\r\n", "\n") + this.httpMessage.getResponseBody().toString();
    }

    @Override
    public void setData(String data) {
        if (this.httpMessage == null) {
            return;
        }
        String[] parts = data.split("\n\n");
        String header = parts[0].replaceAll("(?<!\r)\n", "\r\n");
        try {
            this.httpMessage.setResponseHeader(header);
        }
        catch (HttpMalformedHeaderException e) {
            LOGGER.warn("Could not Save Header: {}", (Object)header, (Object)e);
            throw new InvalidMessageDataException(Constant.messages.getString("http.panel.model.header.warn.malformed"), e);
        }
        String body = "";
        if (parts.length > 1) {
            body = data.substring(parts[0].length() + 2);
        }
        this.httpMessage.setResponseBody(body);
    }
}

