/*
 * Decompiled with CFR 0.152.
 */
package org.islandoftex.albatross;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.path.PathWalkOption;
import kotlin.io.path.PathsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.islandoftex.albatross.CommandLine;
import org.islandoftex.albatross.FontConfig;
import org.islandoftex.albatross.FontConfigKt;
import org.islandoftex.albatross.FontData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0014\u001a\u00020\u000fH\u0007J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0016\u001a\u00020\u0017H\u0007J\u001e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0004H\u0007J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0014\u001a\u00020\u0004H\u0007J\"\u0010\u0018\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00190\u00112\u0006\u0010\u0014\u001a\u00020\u0004H\u0002J(\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0018\u0010\u001b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00190\u0011H\u0002J\"\u0010\u001c\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00190\u00112\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u001a\u0010\u0003\u001a\u00020\u00048FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007R!\u0010\b\u001a\u00020\t8FX\u0087\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\f\u0010\r\u0012\u0004\b\n\u0010\u0002\u001a\u0004\b\b\u0010\u000bR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/islandoftex/albatross/FontConfig;", "", "()V", "help", "", "getHelp$annotations", "getHelp", "()Ljava/lang/String;", "isAvailable", "", "isAvailable$annotations", "()Z", "isAvailable$delegate", "Lkotlin/Lazy;", "windowSize", "", "filterFonts", "", "Lorg/islandoftex/albatross/FontData;", "list", "charset", "getFonts", "path", "Ljava/nio/file/Path;", "listFonts", "", "parse", "output", "queryFonts", "albatross"})
public final class FontConfig {
    @NotNull
    public static final FontConfig INSTANCE;
    private static final int windowSize;
    @NotNull
    private static final Lazy isAvailable$delegate;

    private FontConfig() {
    }

    @NotNull
    public static final String getHelp() throws IOException {
        String[] stringArray = new String[]{"fc-list", "--help"};
        return CommandLine.INSTANCE.getCommandOutput(CollectionsKt.listOf(stringArray)).get(0);
    }

    @JvmStatic
    public static /* synthetic */ void getHelp$annotations() {
    }

    public static final boolean isAvailable() {
        Lazy lazy = isAvailable$delegate;
        return (Boolean)lazy.getValue();
    }

    @JvmStatic
    public static /* synthetic */ void isAvailable$annotations() {
    }

    /*
     * WARNING - void declaration
     */
    private final List<Map<String, String>> listFonts(String charset) throws IOException {
        List list;
        Object object = new String[]{"fc-list", ":charset=" + charset, "--format", "family=%{family}\\nfamilylang=%{familylang}\\nstyle=%{style}\\nstylelang=%{stylelang}\\nfullname=%{fullname}\\nfullnamelang=%{fullnamelang}\\nslant=%{slant}\\nweight=%{weight}\\nsize=%{size}\\nwidth=%{width}\\naspect=%{aspect}\\npixelsize=%{pixelsize}\\nspacing=%{spacing}\\nfoundry=%{foundry}\\nantialias=%{antialias}\\nhinting=%{hinting}\\nhintstyle=%{hintstyle}\\nverticallayout=%{verticallayout}\\nautohint=%{autohint}\\nglobaladvance=%{globaladvance}\\nfile=%{file}\\nindex=%{index}\\nftface=%{ftface}\\nrasterizer=%{rasterizer}\\noutline=%{outline}\\nscalable=%{scalable}\\ncolor=%{color}\\nscale=%{scale}\\ndpi=%{dpi}\\nrgba=%{rgba}\\nlcdfilter=%{lcdfilter}\\nminspace=%{minspace}\\ncharset=%{charset}\\nlang=%{lang}\\nfontversion=%{fontversion}\\ncapability=%{capability}\\nfontformat=%{fontformat}\\nembolden=%{embolden}\\nembeddedbitmap=%{embeddedbitmap}\\ndecorative=%{decorative}\\nfontfeatures=%{fontfeatures}\\nnamelang=%{namelang}\\nprgname=%{prgname}\\npostscriptname=%{postscriptname}\\nfonthashint=%{fonthashint}\\norder=%{order}\\n"};
        Object it = object = CommandLine.INSTANCE.getCommandOutput(CollectionsKt.listOf(object));
        boolean bl = false;
        Object object2 = it.size() >= windowSize ? object : null;
        if (object2 != null && (object2 = CollectionsKt.windowed$default((Iterable)object2, windowSize, windowSize, false, 4, null)) != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)object2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void $this$associateTo$iv$iv;
                void it2;
                List list2 = (List)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                Iterable $this$associate$iv = (Iterable)it2;
                boolean $i$f$associate = false;
                int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associate$iv, 10)), 16);
                Iterable iterable2 = $this$associate$iv;
                Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
                boolean $i$f$associateTo = false;
                for (Object element$iv$iv : $this$associateTo$iv$iv) {
                    Map map = destination$iv$iv2;
                    String s = (String)element$iv$iv;
                    boolean bl3 = false;
                    Pair<String, String> pair2 = TuplesKt.to(StringsKt.substringBefore$default(s, "=", null, 2, null), StringsKt.substringAfter$default(s, "=", null, 2, null));
                    map.put(pair2.getFirst(), pair2.getSecond());
                }
                collection.add(MapsKt.toMap(destination$iv$iv2));
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private final List<Map<String, String>> queryFonts(Path path) throws IOException {
        return (List)BuildersKt.runBlocking(Dispatchers.getDefault(), (Function2)new Function2<CoroutineScope, Continuation<? super List<? extends Map<String, ? extends String>>>, Object>(path, null){
            int label;
            final /* synthetic */ Path $path;
            {
                this.$path = $path;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(object);
                        this.label = 1;
                        Object object3 = FontConfigKt.mapParallel((Iterable)SequencesKt.toList(SequencesKt.filter(PathsKt.walk(this.$path, new PathWalkOption[0]), queryFonts.1.INSTANCE)), queryFonts.2.INSTANCE, this);
                        if (object3 != object2) return CollectionsKt.flatten((Iterable)object3);
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure($result);
                        Object object3 = $result;
                        return CollectionsKt.flatten((Iterable)object3);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super List<? extends Map<String, String>>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final List<FontData> parse(List<? extends Map<String, String>> output) {
        List list;
        List<? extends Map<String, String>> list2;
        List<? extends Map<String, String>> it = list2 = output;
        boolean bl = false;
        List<Map<String, String>> list3 = !it.isEmpty() ? list2 : null;
        if (list3 != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = list3;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                List<String> list4;
                Object object;
                Path path;
                void it2;
                Map map = (Map)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                Object v = it2.get("file");
                Intrinsics.checkNotNull(v);
                Path path2 = Paths.get((String)v, new String[0]);
                Path path3 = path2;
                Intrinsics.checkNotNullExpressionValue(path2, "get(it[\"file\"]!!)");
                Object v2 = it2.get("fullname");
                Intrinsics.checkNotNull(v2);
                List<String> list5 = (CharSequence)v2;
                if (StringsKt.isBlank((CharSequence)((Object)list5))) {
                    path = path3;
                    boolean bl3 = false;
                    Object v3 = it2.get("family");
                    Intrinsics.checkNotNull(v3);
                    object = v3 + " (family)";
                    path3 = path;
                } else {
                    object = list5;
                }
                String string = (String)object;
                Object v4 = it2.get("style");
                Intrinsics.checkNotNull(v4);
                list5 = FontConfigKt.fromCSVtoList(((Object)StringsKt.trim((CharSequence)((String)v4))).toString());
                if (list5.isEmpty()) {
                    String string2 = string;
                    path = path3;
                    boolean bl4 = false;
                    List<String> list6 = CollectionsKt.listOf("No styles defined");
                    path3 = path;
                    string = string2;
                    list4 = list6;
                } else {
                    list4 = list5;
                }
                List list7 = list4;
                Object v5 = it2.get("fontformat");
                Intrinsics.checkNotNull(v5);
                String string3 = (String)v5;
                Object v6 = it2.get("charset");
                Intrinsics.checkNotNull(v6);
                List<IntRange> list8 = FontConfigKt.toIntRangeList((String)v6);
                String string4 = string3;
                List list9 = list7;
                String string5 = string;
                Path path4 = path3;
                collection.add(new FontData(path4, string5, list9, string4, list8));
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @JvmStatic
    @NotNull
    public static final List<FontData> getFonts(@NotNull String charset) throws IOException {
        Intrinsics.checkNotNullParameter(charset, "charset");
        return INSTANCE.parse(INSTANCE.listFonts(charset));
    }

    @JvmStatic
    @NotNull
    public static final List<FontData> getFonts(@NotNull Path path) throws IOException {
        Intrinsics.checkNotNullParameter(path, "path");
        return INSTANCE.parse(INSTANCE.queryFonts(path));
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final List<FontData> filterFonts(@NotNull List<FontData> list, int charset) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(list, "list");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            FontData it = (FontData)element$iv$iv;
            boolean bl = false;
            if (!it.contains(charset)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @JvmStatic
    @NotNull
    public static final List<FontData> getFonts(@NotNull Path path, @NotNull String charset) throws IOException {
        Intrinsics.checkNotNullParameter(path, "path");
        Intrinsics.checkNotNullParameter(charset, "charset");
        return FontConfig.filterFonts(FontConfig.getFonts(path), Integer.parseInt(charset, CharsKt.checkRadix(16)));
    }

    public static final /* synthetic */ int access$getWindowSize$p() {
        return windowSize;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var2_2;
        INSTANCE = new FontConfig();
        CharSequence $this$count$iv = "family=%{family}\\nfamilylang=%{familylang}\\nstyle=%{style}\\nstylelang=%{stylelang}\\nfullname=%{fullname}\\nfullnamelang=%{fullnamelang}\\nslant=%{slant}\\nweight=%{weight}\\nsize=%{size}\\nwidth=%{width}\\naspect=%{aspect}\\npixelsize=%{pixelsize}\\nspacing=%{spacing}\\nfoundry=%{foundry}\\nantialias=%{antialias}\\nhinting=%{hinting}\\nhintstyle=%{hintstyle}\\nverticallayout=%{verticallayout}\\nautohint=%{autohint}\\nglobaladvance=%{globaladvance}\\nfile=%{file}\\nindex=%{index}\\nftface=%{ftface}\\nrasterizer=%{rasterizer}\\noutline=%{outline}\\nscalable=%{scalable}\\ncolor=%{color}\\nscale=%{scale}\\ndpi=%{dpi}\\nrgba=%{rgba}\\nlcdfilter=%{lcdfilter}\\nminspace=%{minspace}\\ncharset=%{charset}\\nlang=%{lang}\\nfontversion=%{fontversion}\\ncapability=%{capability}\\nfontformat=%{fontformat}\\nembolden=%{embolden}\\nembeddedbitmap=%{embeddedbitmap}\\ndecorative=%{decorative}\\nfontfeatures=%{fontfeatures}\\nnamelang=%{namelang}\\nprgname=%{prgname}\\npostscriptname=%{postscriptname}\\nfonthashint=%{fonthashint}\\norder=%{order}\\n";
        boolean $i$f$count = false;
        int count$iv = 0;
        for (int i = 0; i < $this$count$iv.length(); ++i) {
            char element$iv;
            char it = element$iv = $this$count$iv.charAt(i);
            boolean bl = false;
            if (!(it == '%')) continue;
            ++count$iv;
        }
        windowSize = var2_2;
        isAvailable$delegate = LazyKt.lazy(isAvailable.2.INSTANCE);
    }
}

