/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.pegparser;

import com.oracle.graal.python.pegparser.CopyWithContextVisitor;
import com.oracle.graal.python.pegparser.InputType;
import com.oracle.graal.python.pegparser.NodeFactory;
import com.oracle.graal.python.pegparser.ParserCallbacks;
import com.oracle.graal.python.pegparser.RuleResultCache;
import com.oracle.graal.python.pegparser.StringParser;
import com.oracle.graal.python.pegparser.sst.ArgTy;
import com.oracle.graal.python.pegparser.sst.CmpOpTy;
import com.oracle.graal.python.pegparser.sst.ComprehensionTy;
import com.oracle.graal.python.pegparser.sst.ConstantValue;
import com.oracle.graal.python.pegparser.sst.ExprContextTy;
import com.oracle.graal.python.pegparser.sst.ExprTy;
import com.oracle.graal.python.pegparser.sst.KeywordTy;
import com.oracle.graal.python.pegparser.sst.ModTy;
import com.oracle.graal.python.pegparser.sst.PatternTy;
import com.oracle.graal.python.pegparser.sst.SSTNode;
import com.oracle.graal.python.pegparser.sst.StmtTy;
import com.oracle.graal.python.pegparser.sst.TypeIgnoreTy;
import com.oracle.graal.python.pegparser.tokenizer.CodePoints;
import com.oracle.graal.python.pegparser.tokenizer.SourceRange;
import com.oracle.graal.python.pegparser.tokenizer.Token;
import com.oracle.graal.python.pegparser.tokenizer.Tokenizer;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.function.Supplier;
import org.graalvm.shadowed.com.ibm.icu.text.Normalizer2;

public abstract class AbstractParser {
    static final ExprTy[] EMPTY_EXPR_ARRAY = new ExprTy[0];
    static final KeywordTy[] EMPTY_KEYWORD_ARRAY = new KeywordTy[0];
    static final ArgTy[] EMPTY_ARG_ARRAY = new ArgTy[0];
    private static final String BARRY_AS_BDFL = "with Barry as BDFL, use '<>' instead of '!='";
    private int currentPos = 0;
    private final ArrayList<Token> tokens;
    private final Tokenizer tokenizer;
    final ParserCallbacks callbacks;
    protected final NodeFactory factory;
    private final InputType startRule;
    private final EnumSet<Flags> flags;
    final int featureVersion;
    protected int level = 0;
    boolean callInvalidRules = false;
    private boolean parsingStarted;
    private ExprTy.Name cachedDummyName;
    protected final RuleResultCache<Object> cache = new RuleResultCache(this);
    protected final ArrayList<TypeIgnoreTy> comments = new ArrayList();
    private final Object[][][] reservedKeywords;
    private final String[] softKeywords;

    protected abstract Object[][][] getReservedKeywords();

    protected abstract String[] getSoftKeywords();

    protected abstract SSTNode runParser(InputType var1);

    AbstractParser(String source, SourceRange sourceRange, ParserCallbacks callbacks, InputType startRule, EnumSet<Flags> flags, int featureVersion) {
        this.tokens = new ArrayList();
        this.tokenizer = Tokenizer.fromString(callbacks, source, AbstractParser.getTokenizerFlags(startRule, flags), sourceRange);
        this.factory = new NodeFactory();
        this.callbacks = callbacks;
        this.reservedKeywords = this.getReservedKeywords();
        this.softKeywords = this.getSoftKeywords();
        this.startRule = startRule;
        this.flags = flags;
        this.featureVersion = featureVersion;
    }

    private static EnumSet<Tokenizer.Flag> getTokenizerFlags(InputType type, EnumSet<Flags> parserFlags) {
        EnumSet<Tokenizer.Flag> flags = EnumSet.noneOf(Tokenizer.Flag.class);
        if (type == InputType.FILE) {
            flags.add(Tokenizer.Flag.EXEC_INPUT);
        } else if (type == InputType.SINGLE && parserFlags.contains((Object)Flags.INTERACTIVE_TERMINAL)) {
            flags.add(Tokenizer.Flag.INTERACTIVE);
        }
        if (parserFlags.contains((Object)Flags.TYPE_COMMENTS)) {
            flags.add(Tokenizer.Flag.TYPE_COMMENT);
        }
        if (parserFlags.contains((Object)Flags.ASYNC_HACKS)) {
            flags.add(Tokenizer.Flag.ASYNC_HACKS);
        }
        return flags;
    }

    public SSTNode parse() {
        SSTNode res = this.runParser(this.startRule);
        if (res == null) {
            if (this.flags.contains((Object)Flags.ALLOW_INCOMPLETE_INPUT) && (this.tokenizer.getDone() == Tokenizer.StatusCode.EOF || this.tokenizer.getDone() == Tokenizer.StatusCode.EOF_IN_SINGLE_QUOTED_STRING || this.tokenizer.getDone() == Tokenizer.StatusCode.EOF_IN_TRIPLE_QUOTED_STRING)) {
                throw this.raiseSyntaxError("incomplete input", new Object[0]);
            }
            Token lastToken = this.getFill() > 0 ? this.peekToken(this.getFill() - 1) : null;
            this.resetParserState();
            this.runParser(this.startRule);
            int fill = this.getFill();
            if (fill == 0) {
                throw this.raiseSyntaxError("error at start before reading any input", new Object[0]);
            }
            assert (lastToken != null);
            if (lastToken.type == 66 && this.tokenizer.getDone() == Tokenizer.StatusCode.EOF) {
                if (this.tokenizer.getParensNestingLevel() > 0) {
                    throw this.raiseUnclosedParenthesesError();
                }
                throw this.raiseSyntaxError("unexpected EOF while parsing", new Object[0]);
            }
            if (lastToken.type == 5) {
                throw this.raiseIndentationError("unexpected indent", new Object[0]);
            }
            if (lastToken.type == 6) {
                throw this.raiseIndentationError("unexpected unindent", new Object[0]);
            }
            this.tokenizeFullSourceToCheckForErrors(lastToken);
            throw this.raiseSyntaxErrorKnownLocation(lastToken, "invalid syntax", new Object[0]);
        }
        if (this.startRule == InputType.SINGLE && this.tokenizer.isBadSingleStatement()) {
            throw this.raiseSyntaxError("multiple statements found while compiling a single statement", new Object[0]);
        }
        return res;
    }

    void tokenizeFullSourceToCheckForErrors(Token currentToken) {
        block3: {
            int errorLineNo;
            Token t;
            if (this.flags.contains((Object)Flags.INTERACTIVE_TERMINAL)) {
                return;
            }
            do {
                t = this.tokenizer.next();
                if (t.type == 0) break block3;
            } while (t.type != 66);
            if (this.tokenizer.getParensNestingLevel() != 0 && currentToken.getSourceRange().startLine > (errorLineNo = this.tokenizer.getParensLineNumberStack()[this.tokenizer.getParensNestingLevel() - 1])) {
                throw this.raiseUnclosedParenthesesError();
            }
            throw this.tokenizerError(t);
        }
    }

    private void resetParserState() {
        this.callInvalidRules = true;
        this.level = 0;
        this.cache.clear();
        this.currentPos = 0;
        this.tokenizer.reportIncompleteSourceIfInteractive = false;
    }

    public int mark() {
        return this.currentPos;
    }

    public void reset(int position) {
        this.currentPos = position;
    }

    public Token expect(int tokenKind) {
        Token token = this.getAndInitializeToken();
        if (token.type == tokenKind) {
            ++this.currentPos;
            return token;
        }
        return null;
    }

    public Token expect(String text) {
        Token token = this.getAndInitializeToken();
        if (text.equals(this.getText(token))) {
            ++this.currentPos;
            return token;
        }
        return null;
    }

    protected boolean lookahead(boolean match, int kind) {
        int pos = this.mark();
        Token token = this.expect(kind);
        this.reset(pos);
        return token != null == match;
    }

    protected boolean lookahead(boolean match, String text) {
        int pos = this.mark();
        Token token = this.expect(text);
        this.reset(pos);
        return token != null == match;
    }

    public String getText(Token token) {
        if (token == null) {
            return null;
        }
        return this.tokenizer.getTokenCodePoints(token).toJavaString();
    }

    public Token getAndInitializeToken() {
        if (this.currentPos < this.getFill()) {
            return this.peekToken(this.currentPos);
        }
        Token token = this.tokenizer.next();
        while (token.type == 58) {
            String tag = this.getText(token);
            this.comments.add(this.factory.createTypeIgnore(token.sourceRange.startLine, tag, token.sourceRange));
            token = this.tokenizer.next();
        }
        if (this.startRule == InputType.SINGLE && token.type == 0 && this.parsingStarted) {
            token.type = 4;
            this.parsingStarted = false;
            if (this.tokenizer.getCurrentIndentIndex() > 0) {
                this.tokenizer.setPendingIndents(-this.tokenizer.getCurrentIndentIndex());
                this.tokenizer.setCurrentIndentIndex(0);
            }
        } else {
            this.parsingStarted = true;
        }
        this.tokens.add(token);
        return this.initializeToken(token);
    }

    public Token getLastNonWhitespaceToken() {
        Token t = null;
        for (int i = this.mark() - 1; i >= 0; --i) {
            t = this.peekToken(i);
            if (t.type != 0 && (t.type < 4 || t.type > 6)) break;
        }
        return t;
    }

    public ExprTy.Name name_token() {
        Token t = this.expect(1);
        if (t != null) {
            return this.name_from_token(t);
        }
        return null;
    }

    public int countDots(Token[] tokenArray) {
        int cnt = 0;
        for (Token t : tokenArray) {
            if (t.type == 52) {
                cnt += 3;
                continue;
            }
            assert (t.type == 23);
            ++cnt;
        }
        return cnt;
    }

    protected ExprTy.Name expect_SOFT_KEYWORD(String keyword) {
        Token t = this.getAndInitializeToken();
        if (t.type == 1 && this.getText(t).equals(keyword)) {
            ++this.currentPos;
            return this.factory.createVariable(this.getText(t), t.sourceRange);
        }
        return null;
    }

    public Token string_token() {
        return this.expect(3);
    }

    public ExprTy number_token() {
        Token t = this.expect(2);
        if (t == null) {
            return null;
        }
        String number = this.getText(t);
        if (number.contains("_")) {
            if (this.featureVersion < 6) {
                throw this.raiseSyntaxError("Underscores in numeric literals are only supported in Python 3.6 and greater", new Object[0]);
            }
            number = number.replace("_", "");
        }
        int base = 10;
        int start = 0;
        boolean isFloat = false;
        boolean isComplex = false;
        if (number.startsWith("0")) {
            if (number.startsWith("0x") || number.startsWith("0X")) {
                base = 16;
                start = 2;
            } else if (number.startsWith("0o") || number.startsWith("0O")) {
                base = 8;
                start = 2;
            } else if (number.startsWith("0b") || number.startsWith("0B")) {
                base = 2;
                start = 2;
            }
        }
        if (base == 10) {
            boolean bl = isComplex = number.endsWith("j") || number.endsWith("J");
            if (!isComplex) {
                boolean bl2 = isFloat = number.contains(".") || number.contains("e") || number.contains("E");
            }
        }
        if (isComplex) {
            double imag = Double.parseDouble(number.substring(0, number.length() - 1));
            return this.factory.createConstant(ConstantValue.ofComplex(0.0, imag), t.sourceRange);
        }
        if (isFloat) {
            return this.factory.createConstant(ConstantValue.ofDouble(Double.parseDouble(number)), t.sourceRange);
        }
        long max = Long.MAX_VALUE;
        long moltmax = Long.MAX_VALUE / (long)base;
        long result = 0L;
        boolean overunder = false;
        for (int i = start; i < number.length(); ++i) {
            int lastD = AbstractParser.digitValue(number.charAt(i));
            long next = result;
            if (next > moltmax) {
                overunder = true;
            } else if ((next *= (long)base) > Long.MAX_VALUE - (long)lastD) {
                overunder = true;
            } else {
                next += (long)lastD;
            }
            if (overunder) {
                BigInteger bigResult = BigInteger.valueOf(result);
                BigInteger bigBase = BigInteger.valueOf(base);
                while (i < number.length()) {
                    bigResult = bigResult.multiply(bigBase).add(BigInteger.valueOf(AbstractParser.digitValue(number.charAt(i))));
                    ++i;
                }
                return this.factory.createConstant(ConstantValue.ofBigInteger(bigResult), t.sourceRange);
            }
            result = next;
        }
        return this.factory.createConstant(ConstantValue.ofLong(result), t.sourceRange);
    }

    private static int digitValue(char ch) {
        if (ch >= '0' && ch <= '9') {
            return ch - 48;
        }
        if (ch >= 'a' && ch <= 'f') {
            return ch - 97 + 10;
        }
        assert (ch >= 'A' && ch <= 'f');
        return ch - 65 + 10;
    }

    public Token expect_forced_token(int kind, String expected) {
        Token t = this.getAndInitializeToken();
        if (t.type != kind) {
            throw this.raiseSyntaxErrorKnownLocation(t, "expected '%s'", expected);
        }
        ++this.currentPos;
        return t;
    }

    public ExprTy.Name name_from_token(Token t) {
        if (t == null) {
            return null;
        }
        String id = this.getText(t);
        for (int i = 0; i < id.length(); ++i) {
            if (id.charAt(i) <= '\u00ff') continue;
            id = Normalizer2.getNFKCInstance().normalize((CharSequence)id);
            break;
        }
        return this.factory.createVariable(id, t.sourceRange);
    }

    public ExprTy.Name soft_keyword_token() {
        Token t = this.expect(1);
        if (t == null) {
            return null;
        }
        String txt = this.getText(t);
        for (String s : this.softKeywords) {
            if (!s.equals(txt)) continue;
            return this.name_from_token(t);
        }
        return null;
    }

    public ExprTy.Name dummyName(Object ... args) {
        if (this.cachedDummyName != null) {
            return this.cachedDummyName;
        }
        this.cachedDummyName = this.factory.createVariable("", SourceRange.ARTIFICIAL_RANGE);
        return this.cachedDummyName;
    }

    public SSTNode joinNamesWithDot(ExprTy a, ExprTy b) {
        String id = ((ExprTy.Name)a).id + "." + ((ExprTy.Name)b).id;
        return this.factory.createVariable(id, a.getSourceRange().withEnd(b.getSourceRange()));
    }

    public <T> T[] insertInFront(T element, T[] seq, Class<T> clazz) {
        Object[] result;
        if (seq == null) {
            result = (Object[])Array.newInstance(clazz, 1);
        } else {
            result = Arrays.copyOf(seq, seq.length + 1);
            System.arraycopy(seq, 0, result, 1, seq.length);
        }
        result[0] = element;
        return result;
    }

    public ExprTy[] insertInFront(ExprTy element, ExprTy[] seq) {
        return this.insertInFront(element, seq, ExprTy.class);
    }

    public PatternTy[] insertInFront(PatternTy element, PatternTy[] seq) {
        return this.insertInFront(element, seq, PatternTy.class);
    }

    public <T> T[] appendToEnd(T[] seq, T element, Class<T> clazz) {
        Object[] result;
        if (seq == null) {
            result = (Object[])Array.newInstance(clazz, 1);
            result[0] = element;
        } else {
            result = Arrays.copyOf(seq, seq.length + 1);
            result[seq.length] = element;
        }
        return result;
    }

    public ExprTy[] appendToEnd(ExprTy[] seq, ExprTy element) {
        return this.appendToEnd(seq, element, ExprTy.class);
    }

    private ExprTy.Constant decodeFStringPart(boolean isRaw, ExprTy.Constant constant, Token token) {
        assert (constant.value.kind == ConstantValue.Kind.CODEPOINTS);
        CodePoints cp = constant.value.getCodePoints();
        CodePoints str = cp.getLength() == 2 && cp.get(0) == cp.get(1) && (cp.get(0) == 123 || cp.get(0) == 125) ? cp.withLength(1) : StringParser.decodeString(this, isRaw, cp, token);
        return this.factory.createConstant(ConstantValue.ofCodePoints(str), constant.getSourceRange());
    }

    private static ExprTy[] unpackTopLevelJoinedStrs(ExprTy[] rawExpressions) {
        int reqSize = 0;
        for (ExprTy expr : rawExpressions) {
            if (expr instanceof ExprTy.JoinedStr) {
                ExprTy.JoinedStr joinedStr = (ExprTy.JoinedStr)expr;
                reqSize += joinedStr.values.length;
                continue;
            }
            ++reqSize;
        }
        ExprTy[] expressions = new ExprTy[reqSize];
        int reqIndex = 0;
        for (ExprTy expr : rawExpressions) {
            if (expr instanceof ExprTy.JoinedStr) {
                ExprTy.JoinedStr joinedStr = (ExprTy.JoinedStr)expr;
                ExprTy[] values = joinedStr.values;
                System.arraycopy(values, 0, expressions, reqIndex, values.length);
                reqIndex += values.length;
                continue;
            }
            expressions[reqIndex++] = expr;
        }
        return expressions;
    }

    public ExprTy joinedStr(Token a, ExprTy[] rawExpressions, Token b) {
        ExprTy[] expr = AbstractParser.unpackTopLevelJoinedStrs(rawExpressions);
        int nItems = expr.length;
        CodePoints quoteStr = this.tokenizer.getTokenCodePoints(a);
        boolean isRaw = quoteStr.contains(114) || quoteStr.contains(82);
        ExprTy[] seq = new ExprTy[nItems];
        int index = 0;
        for (ExprTy item : expr) {
            if (item instanceof ExprTy.Constant) {
                ExprTy.Constant constant = (ExprTy.Constant)item;
                constant = this.decodeFStringPart(isRaw, constant, b);
                item = constant;
                if (constant.value.kind == ConstantValue.Kind.CODEPOINTS && constant.value.getCodePoints().isEmpty()) continue;
            }
            seq[index++] = item;
        }
        ExprTy[] resizedExprs = Arrays.copyOf(seq, index);
        return this.factory.createJoinedStr(resizedExprs, a.sourceRange.withEnd(b.sourceRange));
    }

    public ExprTy decodedConstantFromToken(Token tok) {
        CodePoints cv = StringParser.decodeString(this, false, this.tokenizer.getTokenCodePoints(tok), tok);
        return this.factory.createConstant(ConstantValue.ofCodePoints(cv), tok.getSourceRange());
    }

    public SSTNode constantFromToken(Token tok) {
        return this.factory.createConstant(ConstantValue.ofCodePoints(this.tokenizer.getTokenCodePoints(tok)), tok.sourceRange);
    }

    public ExprTy constantFromString(Token tok) {
        CodePoints cp = this.tokenizer.getTokenCodePoints(tok);
        String kind = cp.get(0) == 117 ? "u" : null;
        ConstantValue cv = StringParser.parseString(this, cp, tok);
        return this.factory.createConstant(cv, kind, tok.getSourceRange());
    }

    public ExprTy formattedValue(ExprTy expression, Token debug, ResultTokenWithMetadata conversion, ResultTokenWithMetadata format, Token closingBrace, SourceRange sourceRange) {
        int conversionVal = -1;
        if (conversion != null) {
            char first;
            assert (conversion.result() instanceof ExprTy.Name);
            String conversionKind = ((ExprTy.Name)conversion.result()).id;
            char c = first = conversionKind.length() == 1 ? conversionKind.charAt(0) : (char)'\u0000';
            if (first != 's' && first != 'r' && first != 'a') {
                throw this.raiseSyntaxErrorKnownLocation(conversion.result(), "f-string: invalid conversion character '%s': expected 's', 'r', or 'a'", conversionKind);
            }
            conversionVal = first;
        } else if (debug != null && format == null) {
            conversionVal = 114;
        }
        ExprTy.FormattedValue formattedValue = this.factory.createFormattedValue(expression, conversionVal, format != null ? format.result : null, sourceRange);
        if (debug != null) {
            CodePoints debugMetadata;
            int debugEndColumn;
            int debugEndLine;
            if (conversion != null) {
                debugEndLine = conversion.result.getSourceRange().startLine;
                debugEndColumn = conversion.result.getSourceRange().startColumn;
                debugMetadata = conversion.metadata;
            } else if (format != null) {
                debugEndLine = format.result.getSourceRange().startLine;
                debugEndColumn = format.result.getSourceRange().startColumn + 1;
                debugMetadata = format.metadata;
            } else {
                debugEndLine = sourceRange.endLine;
                debugEndColumn = sourceRange.endColumn;
                debugMetadata = closingBrace.metadata;
            }
            ExprTy.Constant debugText = this.factory.createConstant(ConstantValue.ofCodePoints(debugMetadata), new SourceRange(sourceRange.startLine, sourceRange.startColumn + 1, debugEndLine, debugEndColumn - 1));
            return this.factory.createJoinedStr(new ExprTy[]{debugText, formattedValue}, new SourceRange(sourceRange.startLine, sourceRange.startColumn, debugEndLine, debugEndColumn));
        }
        return formattedValue;
    }

    /*
     * WARNING - void declaration
     */
    public ExprTy concatenateStrings(ExprTy[] strings, SourceRange sourceRange) {
        boolean fStringFound = false;
        boolean unicodeStringFound = false;
        boolean bytesFound = false;
        int nFlattenedElements = 0;
        for (ExprTy elem : strings) {
            if (elem instanceof ExprTy.Constant) {
                ExprTy.Constant constant = (ExprTy.Constant)elem;
                if (constant.value.kind == ConstantValue.Kind.BYTES) {
                    bytesFound = true;
                } else {
                    unicodeStringFound = true;
                }
                ++nFlattenedElements;
                continue;
            }
            if (elem instanceof ExprTy.JoinedStr) {
                ExprTy.JoinedStr joinedStr = (ExprTy.JoinedStr)elem;
                nFlattenedElements += joinedStr.values.length;
                fStringFound = true;
                continue;
            }
            ++nFlattenedElements;
            fStringFound = true;
        }
        if ((unicodeStringFound || fStringFound) && bytesFound) {
            throw this.raiseSyntaxError("cannot mix bytes and nonbytes literals", new Object[0]);
        }
        if (bytesFound) {
            Object kind = ((ExprTy.Constant)strings[0]).kind;
            int totalLen = 0;
            for (ExprTy elem : strings) {
                totalLen += ((ExprTy.Constant)elem).value.getBytes().length;
            }
            byte[] dest = new byte[totalLen];
            int offset = 0;
            for (ExprTy exprTy : strings) {
                byte[] src = ((ExprTy.Constant)exprTy).value.getBytes();
                System.arraycopy(src, 0, dest, offset, src.length);
                offset += src.length;
            }
            return this.factory.createConstant(ConstantValue.ofBytes(dest), kind, sourceRange);
        }
        if (!fStringFound && strings.length == 1) {
            return strings[0];
        }
        ExprTy[] flattened = new ExprTy[nFlattenedElements];
        int curPos = 0;
        for (ExprTy elem : strings) {
            if (elem instanceof ExprTy.JoinedStr) {
                ExprTy.JoinedStr joined = (ExprTy.JoinedStr)elem;
                for (ExprTy subvalue : joined.values) {
                    flattened[curPos++] = subvalue;
                }
                continue;
            }
            flattened[curPos++] = elem;
        }
        int nElements = 0;
        boolean prevIsConstant = false;
        for (ExprTy exprTy : flattened) {
            if (fStringFound && exprTy instanceof ExprTy.Constant) {
                ExprTy.Constant constant = (ExprTy.Constant)exprTy;
                if (constant.value.kind == ConstantValue.Kind.CODEPOINTS && constant.value.getCodePoints().isEmpty()) continue;
            }
            if (!prevIsConstant || !(exprTy instanceof ExprTy.Constant)) {
                ++nElements;
            }
            prevIsConstant = exprTy instanceof ExprTy.Constant;
        }
        ExprTy[] values = new ExprTy[nElements];
        curPos = 0;
        for (int i = 0; i < flattened.length; ++i) {
            ExprTy elem = flattened[i];
            if (elem instanceof ExprTy.Constant) {
                void var14_36;
                ExprTy.Constant constant = (ExprTy.Constant)elem;
                if (i + 1 < flattened.length && flattened[i + 1] instanceof ExprTy.Constant) {
                    ExprTy currentElem;
                    int j;
                    ExprTy.Constant firstElemConst = constant;
                    Object kind = constant.kind;
                    CodePoints.Builder writer = new CodePoints.Builder(0);
                    ExprTy.Constant lastElemConst = constant;
                    for (j = i; j < flattened.length && (currentElem = flattened[j]) instanceof ExprTy.Constant; ++j) {
                        ExprTy.Constant currentElemConst = (ExprTy.Constant)currentElem;
                        writer.appendCodePoints(currentElemConst.value.getCodePoints());
                        lastElemConst = currentElemConst;
                    }
                    i = j - 1;
                    ExprTy.Constant constant2 = this.factory.createConstant(ConstantValue.ofCodePoints(writer.build()), kind, firstElemConst.getSourceRange().withEnd(lastElemConst.getSourceRange()));
                    elem = constant2;
                }
                if (fStringFound && var14_36.value.kind == ConstantValue.Kind.CODEPOINTS && var14_36.value.getCodePoints().isEmpty()) continue;
            }
            values[curPos++] = elem;
        }
        if (!fStringFound) {
            assert (nElements == 1);
            ExprTy elem = values[0];
            assert (elem instanceof ExprTy.Constant);
            return elem;
        }
        assert (curPos == nElements);
        return this.factory.createJoinedStr(values, sourceRange);
    }

    public boolean checkBarryAsFlufl(Token token) {
        if (this.flags.contains((Object)Flags.BARRY_AS_BDFL) && !this.getText(token).equals("<>")) {
            throw this.callbacks.onError(ParserCallbacks.ErrorType.Generic, token.sourceRange, BARRY_AS_BDFL);
        }
        return !this.flags.contains((Object)Flags.BARRY_AS_BDFL) && !this.getText(token).equals("!=");
    }

    public boolean checkLegacyStmt(ExprTy name) {
        String[] candidates;
        if (!(name instanceof ExprTy.Name)) {
            return false;
        }
        for (String candidate : candidates = new String[]{"print", "exec"}) {
            if (!candidate.equals(((ExprTy.Name)name).id)) continue;
            return true;
        }
        return false;
    }

    ResultTokenWithMetadata checkFstringConversion(Token convToken, ExprTy conv) {
        if (convToken.sourceRange.startLine != conv.getSourceRange().startLine || convToken.sourceRange.endColumn != conv.getSourceRange().startColumn) {
            throw this.raiseSyntaxErrorKnownRange(convToken, (SSTNode)conv, "f-string: conversion type must come right after the exclamanation mark", new Object[0]);
        }
        return new ResultTokenWithMetadata(conv, convToken.metadata);
    }

    /*
     * Unable to fully structure code
     */
    ResultTokenWithMetadata setupFullFormatSpec(Token colon, ExprTy[] spec, SourceRange sourceRange) {
        if (spec.length != 1 || !((var6_4 = spec[0]) instanceof ExprTy.Constant)) ** GOTO lbl-1000
        constant = (ExprTy.Constant)var6_4;
        if (constant.value.kind == ConstantValue.Kind.CODEPOINTS && constant.value.getCodePoints().isEmpty()) {
            fixedSpec = new ExprTy[]{};
        } else lbl-1000:
        // 2 sources

        {
            fixedSpec = spec;
        }
        res = fixedSpec.length == 0 || fixedSpec.length == 1 && fixedSpec[0] instanceof ExprTy.Constant != false ? this.factory.createJoinedStr(fixedSpec, sourceRange) : this.concatenateStrings(fixedSpec, sourceRange);
        return new ResultTokenWithMetadata(res, colon.metadata);
    }

    public String getExprName(ExprTy e) {
        if (e instanceof ExprTy.Attribute || e instanceof ExprTy.Subscript || e instanceof ExprTy.Starred || e instanceof ExprTy.Name || e instanceof ExprTy.Tuple || e instanceof ExprTy.List || e instanceof ExprTy.Lambda) {
            return e.getClass().getSimpleName().toLowerCase();
        }
        if (e instanceof ExprTy.Call) {
            return "function call";
        }
        if (e instanceof ExprTy.BoolOp || e instanceof ExprTy.BinOp || e instanceof ExprTy.UnaryOp) {
            return "expression";
        }
        if (e instanceof ExprTy.GeneratorExp) {
            return "generator expression";
        }
        if (e instanceof ExprTy.Yield || e instanceof ExprTy.YieldFrom) {
            return "yield expression";
        }
        if (e instanceof ExprTy.Await) {
            return "await expression";
        }
        if (e instanceof ExprTy.ListComp) {
            return "list comprehension";
        }
        if (e instanceof ExprTy.SetComp) {
            return "set comprehension";
        }
        if (e instanceof ExprTy.DictComp) {
            return "dict comprehension";
        }
        if (e instanceof ExprTy.Dict) {
            return "dict literal";
        }
        if (e instanceof ExprTy.Set) {
            return "set display";
        }
        if (e instanceof ExprTy.JoinedStr || e instanceof ExprTy.FormattedValue) {
            return "f-string expression";
        }
        if (e instanceof ExprTy.Constant) {
            ExprTy.Constant constant = (ExprTy.Constant)e;
            switch (constant.value.kind) {
                case NONE: {
                    return "None";
                }
                case BOOLEAN: {
                    return constant.value.getBoolean() ? "True" : "False";
                }
                case ELLIPSIS: {
                    return "ellipsis";
                }
            }
            return "literal";
        }
        if (e instanceof ExprTy.Compare) {
            return "comparision";
        }
        if (e instanceof ExprTy.IfExp) {
            return "conditional expression";
        }
        if (e instanceof ExprTy.NamedExpr) {
            return "named expression";
        }
        assert (false) : "unexpected expression " + String.valueOf(e.getClass()) + " in assignment";
        return null;
    }

    private Token initializeToken(Token token) {
        Object[][] kwlist;
        String txt;
        int l;
        if (token.type == 1 && (l = (txt = this.getText(token)).length()) < this.reservedKeywords.length && (kwlist = this.reservedKeywords[l]) != null) {
            for (Object[] kwAssoc : kwlist) {
                if (!txt.equals(kwAssoc[0])) continue;
                token.type = (Integer)kwAssoc[1];
                break;
            }
        }
        if (token.type == 66) {
            throw this.tokenizerError(token);
        }
        return token;
    }

    protected String newTypeComment(Object token) {
        return this.getText((Token)token);
    }

    protected <T> T[] join(T[] a, T[] b) {
        if (a == null && b != null) {
            return b;
        }
        if (a != null && b == null) {
            return a;
        }
        if (a != null) {
            T[] result = Arrays.copyOf(a, a.length + b.length);
            System.arraycopy(b, 0, result, a.length, b.length);
            return result;
        }
        return null;
    }

    protected ExprTy setExprContext(ExprTy node, ExprContextTy context) {
        return node.accept(new CopyWithContextVisitor(context));
    }

    private void indent(StringBuilder sb) {
        for (int i = 0; i < this.level; ++i) {
            sb.append("  ");
        }
    }

    void debugMessageln(String text, Object ... args) {
        StringBuilder sb = new StringBuilder();
        this.indent(sb);
        sb.append(String.format(text, args));
        System.out.println(sb);
    }

    static ExprTy[] extractKeys(KeyValuePair[] l) {
        int len = l == null ? 0 : l.length;
        ExprTy[] keys = new ExprTy[len];
        for (int i = 0; i < len; ++i) {
            keys[i] = l[i].key;
        }
        return keys;
    }

    static ExprTy[] extractValues(KeyValuePair[] l) {
        int len = l == null ? 0 : l.length;
        ExprTy[] values = new ExprTy[len];
        for (int i = 0; i < len; ++i) {
            values[i] = l[i].value;
        }
        return values;
    }

    static ExprTy[] extractKeys(KeyPatternPair[] l) {
        int len = l == null ? 0 : l.length;
        ExprTy[] keys = new ExprTy[len];
        for (int i = 0; i < len; ++i) {
            keys[i] = l[i].key;
        }
        return keys;
    }

    static PatternTy[] extractPatterns(KeyPatternPair[] l) {
        int len = l == null ? 0 : l.length;
        PatternTy[] values = new PatternTy[len];
        for (int i = 0; i < len; ++i) {
            values[i] = l[i].pattern;
        }
        return values;
    }

    static ExprTy[] extractStarredExpressions(KeywordOrStarred[] kwds) {
        ArrayList<ExprTy> list = new ArrayList<ExprTy>();
        for (KeywordOrStarred n : kwds) {
            if (n.isKeyword) continue;
            ExprTy element = (ExprTy)n.element;
            list.add(element);
        }
        return list.toArray(new ExprTy[0]);
    }

    static KeywordTy[] deleteStarredExpressions(KeywordOrStarred[] kwds) {
        ArrayList<KeywordTy> list = new ArrayList<KeywordTy>();
        for (KeywordOrStarred n : kwds) {
            if (!n.isKeyword) continue;
            KeywordTy element = (KeywordTy)n.element;
            list.add(element);
        }
        return list.toArray(new KeywordTy[0]);
    }

    static String[] extractNames(ExprTy[] seq) {
        ArrayList<String> list = new ArrayList<String>();
        for (ExprTy e : seq) {
            String id = ((ExprTy.Name)e).id;
            list.add(id);
        }
        return list.toArray(new String[0]);
    }

    final ExprTy collectCallSequences(ExprTy[] a, KeywordOrStarred[] b, SourceRange sourceRange) {
        ExprTy[] args;
        if (b == null) {
            return this.factory.createCall(this.dummyName(new Object[0]), a, EMPTY_KEYWORD_ARRAY, sourceRange);
        }
        ExprTy[] starred = AbstractParser.extractStarredExpressions(b);
        if (starred.length > 0) {
            args = Arrays.copyOf(a, a.length + starred.length);
            System.arraycopy(starred, 0, args, a.length, starred.length);
        } else {
            args = a;
        }
        return this.factory.createCall(this.dummyName(new Object[0]), args, AbstractParser.deleteStarredExpressions(b), sourceRange);
    }

    private ExprTy visitContainer(ExprTy[] elements, TargetsType type) {
        if (elements == null) {
            return null;
        }
        for (ExprTy expr : elements) {
            ExprTy child = this.getInvalidTarget(expr, type);
            if (child == null) continue;
            return child;
        }
        return null;
    }

    private ExprTy getInvalidTarget(ExprTy expr, TargetsType type) {
        if (expr == null) {
            return null;
        }
        if (expr instanceof ExprTy.List) {
            return this.visitContainer(((ExprTy.List)expr).elements, type);
        }
        if (expr instanceof ExprTy.Tuple) {
            return this.visitContainer(((ExprTy.Tuple)expr).elements, type);
        }
        if (expr instanceof ExprTy.Starred) {
            if (type == TargetsType.DEL_TARGETS) {
                return expr;
            }
            return this.getInvalidTarget(((ExprTy.Starred)expr).value, type);
        }
        if (expr instanceof ExprTy.Compare) {
            if (type == TargetsType.FOR_TARGETS) {
                ExprTy.Compare compare = (ExprTy.Compare)expr;
                if (compare.ops[0] == CmpOpTy.In) {
                    return this.getInvalidTarget(compare.left, type);
                }
                return null;
            }
            return expr;
        }
        if (expr instanceof ExprTy.Name || expr instanceof ExprTy.Subscript || expr instanceof ExprTy.Attribute) {
            return null;
        }
        return expr;
    }

    SSTNode nonparenGenexpInCall(ExprTy args, ComprehensionTy[] comprehensions) {
        assert (args instanceof ExprTy.Call);
        ExprTy.Call call = (ExprTy.Call)args;
        int len = call.args.length;
        if (len <= 1) {
            return null;
        }
        ComprehensionTy lastComprehension = comprehensions[comprehensions.length - 1];
        throw this.raiseSyntaxErrorKnownRange((SSTNode)call.args[len - 1], (SSTNode)this.getLastComprehensionItem(lastComprehension), "Generator expression must be parenthesized", new Object[0]);
    }

    RuntimeException raiseSyntaxErrorInvalidTarget(TargetsType type, ExprTy expr) {
        ExprTy invalidTarget = this.getInvalidTarget(expr, type);
        if (invalidTarget != null) {
            String message = type == TargetsType.STAR_TARGETS || type == TargetsType.FOR_TARGETS ? "cannot assign to %s" : "cannot delete %s";
            throw this.raiseSyntaxErrorKnownLocation(invalidTarget, message, this.getExprName(invalidTarget));
        }
        throw this.raiseSyntaxError("invalid syntax", new Object[0]);
    }

    RuntimeException raiseSyntaxError(String msg, Object ... arguments) {
        Token errorToken = this.peekToken();
        throw this.raiseErrorKnownLocation(ParserCallbacks.ErrorType.Syntax, errorToken.sourceRange, msg, arguments);
    }

    RuntimeException raiseSyntaxErrorOnNextToken(String msg) {
        Token errorToken = this.peekToken();
        throw this.raiseErrorKnownLocation(ParserCallbacks.ErrorType.Syntax, errorToken.sourceRange, msg, new Object[0]);
    }

    RuntimeException raiseSyntaxErrorKnownLocation(Token errorToken, String msg, Object ... arguments) {
        throw this.raiseErrorKnownLocation(ParserCallbacks.ErrorType.Syntax, errorToken.sourceRange, msg, arguments);
    }

    RuntimeException raiseErrorKnownLocation(ParserCallbacks.ErrorType typeError, SourceRange where, String msg, Object ... argument) {
        throw this.callbacks.onError(typeError, where, msg, argument);
    }

    RuntimeException raiseSyntaxErrorKnownLocation(SSTNode where, String msg, Object ... arguments) {
        throw this.raiseErrorKnownLocation(ParserCallbacks.ErrorType.Syntax, where.getSourceRange(), msg, arguments);
    }

    RuntimeException raiseErrorKnownLocation(ParserCallbacks.ErrorType errorType, SSTNode where, String msg, Object ... arguments) {
        throw this.raiseErrorKnownLocation(errorType, where.getSourceRange(), msg, arguments);
    }

    RuntimeException raiseSyntaxErrorKnownRange(Token startToken, SSTNode endNode, String msg, Object ... arguments) {
        throw this.raiseErrorKnownLocation(ParserCallbacks.ErrorType.Syntax, startToken.sourceRange.withEnd(endNode.getSourceRange()), msg, arguments);
    }

    RuntimeException raiseSyntaxErrorKnownRange(Token startToken, Token endToken, String msg, Object ... arguments) {
        throw this.raiseErrorKnownLocation(ParserCallbacks.ErrorType.Syntax, startToken.sourceRange.withEnd(endToken.sourceRange), msg, arguments);
    }

    RuntimeException raiseSyntaxErrorKnownRange(SSTNode startNode, SSTNode endNode, String msg, Object ... arguments) {
        throw this.raiseErrorKnownLocation(ParserCallbacks.ErrorType.Syntax, startNode.getSourceRange().withEnd(endNode.getSourceRange()), msg, arguments);
    }

    RuntimeException raiseSyntaxErrorKnownRange(SSTNode startNode, Token endToken, String msg, Object ... arguments) {
        throw this.raiseErrorKnownLocation(ParserCallbacks.ErrorType.Syntax, startNode.getSourceRange().withEnd(endToken.sourceRange), msg, arguments);
    }

    RuntimeException raiseSyntaxErrorStartingFrom(Token where, String msg, Object ... arguments) {
        throw this.raiseErrorKnownLocation(ParserCallbacks.ErrorType.Syntax, this.tokenizer.extendRangeToCurrentPosition(where.sourceRange), msg, arguments);
    }

    RuntimeException raiseSyntaxErrorStartingFrom(SSTNode where, String msg, Object ... arguments) {
        throw this.raiseErrorKnownLocation(ParserCallbacks.ErrorType.Syntax, this.tokenizer.extendRangeToCurrentPosition(where.getSourceRange()), msg, arguments);
    }

    RuntimeException raiseArgumentsParsingError(ExprTy e) {
        for (KeywordTy keyword : ((ExprTy.Call)e).keywords) {
            if (keyword.arg != null) continue;
            throw this.raiseSyntaxError("positional argument follows keyword argument unpacking", new Object[0]);
        }
        throw this.raiseSyntaxError("positional argument follows keyword argument", new Object[0]);
    }

    RuntimeException raiseIndentationError(String msg, Object ... arguments) {
        Token errorToken = this.peekToken();
        throw this.raiseErrorKnownLocation(ParserCallbacks.ErrorType.Indentation, errorToken.sourceRange, msg, arguments);
    }

    RuntimeException raiseUnclosedParenthesesError() {
        int nestingLevel = this.tokenizer.getParensNestingLevel();
        assert (nestingLevel > 0);
        int errorLineno = this.tokenizer.getParensLineNumberStack()[nestingLevel - 1];
        int errorCol = this.tokenizer.getParensColumnsStack()[nestingLevel - 1];
        throw this.raiseErrorKnownLocation(ParserCallbacks.ErrorType.Syntax, new SourceRange(errorLineno, errorCol, errorLineno, -1), "'%c' was never closed", this.tokenizer.getParensStack()[nestingLevel - 1]);
    }

    RuntimeException tokenizerError(Token token) {
        String msg;
        if (token.type == 66 && this.tokenizer.getDone() == Tokenizer.StatusCode.SYNTAX_ERROR) {
            throw this.raiseErrorKnownLocation(ParserCallbacks.ErrorType.Syntax, token.getSourceRange(), (String)token.extraData, new Object[0]);
        }
        ParserCallbacks.ErrorType errorType = ParserCallbacks.ErrorType.Syntax;
        int colOffset = -1;
        switch (this.tokenizer.getDone()) {
            case BAD_TOKEN: {
                msg = "invalid token";
                break;
            }
            case EOF: {
                if (this.tokenizer.getParensNestingLevel() > 0) {
                    throw this.raiseUnclosedParenthesesError();
                }
                throw this.raiseSyntaxError("unexpected EOF while parsing", new Object[0]);
            }
            case DEDENT_INVALID: {
                throw this.raiseIndentationError("unindent does not match any outer indentation level", new Object[0]);
            }
            case TABS_SPACES_INCONSISTENT: {
                errorType = ParserCallbacks.ErrorType.Tab;
                msg = "inconsistent use of tabs and spaces in indentation";
                break;
            }
            case TOO_DEEP_INDENTATION: {
                errorType = ParserCallbacks.ErrorType.Indentation;
                msg = "too many levels of indentation";
                break;
            }
            case LINE_CONTINUATION_ERROR: {
                msg = "unexpected character after line continuation character";
                colOffset = this.tokenizer.getNextCharIndex() - this.tokenizer.getLineStartIndex();
                break;
            }
            default: {
                msg = "unknown parsing error";
            }
        }
        throw this.raiseErrorKnownLocation(errorType, new SourceRange(this.tokenizer.getCurrentLineNumber(), colOffset >= 0 ? colOffset : 0, this.tokenizer.getCurrentLineNumber(), -1), msg, new Object[0]);
    }

    SSTNode interactiveExit() {
        return null;
    }

    <T> T lastItem(T[] seq) {
        return seq[seq.length - 1];
    }

    ExprTy getLastComprehensionItem(ComprehensionTy comprehension) {
        if (comprehension.ifs == null || comprehension.ifs.length == 0) {
            return comprehension.iter;
        }
        return this.lastItem(comprehension.ifs);
    }

    ExprTy ensureReal(ExprTy e) {
        if (!(e instanceof ExprTy.Constant) || ((ExprTy.Constant)e).value.kind == ConstantValue.Kind.COMPLEX) {
            throw this.raiseSyntaxErrorKnownLocation(e, "real number required in complex literal", new Object[0]);
        }
        return e;
    }

    ExprTy ensureImaginary(ExprTy e) {
        if (!(e instanceof ExprTy.Constant) || ((ExprTy.Constant)e).value.kind != ConstantValue.Kind.COMPLEX) {
            throw this.raiseSyntaxErrorKnownLocation(e, "imaginary number required in complex literal", new Object[0]);
        }
        return e;
    }

    ModTy makeModule(StmtTy[] statements, SourceRange sourceRange) {
        return this.factory.createModule(statements, (TypeIgnoreTy[])this.comments.toArray(TypeIgnoreTy[]::new), sourceRange);
    }

    <T> T checkVersion(int version, String msg, T node) {
        this.checkVersion(version, msg);
        return node;
    }

    <T> T checkVersion(int version, String msg, Supplier<T> node) {
        this.checkVersion(version, msg);
        return node.get();
    }

    private void checkVersion(int version, String msg) {
        if (this.featureVersion < version) {
            throw this.raiseSyntaxError("%s only supported in Python 3.%d and greater", msg, version);
        }
    }

    private int getFill() {
        return this.tokens.size();
    }

    private Token peekToken() {
        if (this.currentPos == this.tokens.size()) {
            Token t = this.tokenizer.next();
            if (t.type != 58) {
                this.tokens.add(t);
            }
            return t;
        }
        return this.tokens.get(this.currentPos);
    }

    protected final Token peekToken(int position) {
        assert (position < this.tokens.size());
        return this.tokens.get(position);
    }

    public static enum Flags {
        BARRY_AS_BDFL,
        TYPE_COMMENTS,
        INTERACTIVE_TERMINAL,
        ASYNC_HACKS,
        ALLOW_INCOMPLETE_INPUT;

    }

    public record ResultTokenWithMetadata(ExprTy result, CodePoints metadata) {
    }

    public static final class KeyValuePair {
        final ExprTy key;
        final ExprTy value;

        KeyValuePair(ExprTy key, ExprTy value) {
            this.key = key;
            this.value = value;
        }
    }

    public static final class KeyPatternPair {
        final ExprTy key;
        final PatternTy pattern;

        KeyPatternPair(ExprTy key, PatternTy pattern) {
            this.key = key;
            this.pattern = pattern;
        }
    }

    public static final class KeywordOrStarred {
        final SSTNode element;
        final boolean isKeyword;

        KeywordOrStarred(SSTNode element, boolean isKeyword) {
            this.element = element;
            this.isKeyword = isKeyword;
        }
    }

    public static enum TargetsType {
        STAR_TARGETS,
        DEL_TARGETS,
        FOR_TARGETS;

    }

    public static final class StarEtc {
        final ArgTy varArg;
        final NameDefaultPair[] kwOnlyArgs;
        final ArgTy kwArg;

        StarEtc(ArgTy varArg, NameDefaultPair[] kwOnlyArgs, ArgTy kwArg) {
            this.varArg = varArg;
            this.kwOnlyArgs = kwOnlyArgs;
            this.kwArg = kwArg;
        }
    }

    public static final class SlashWithDefault {
        final ArgTy[] plainNames;
        final NameDefaultPair[] namesWithDefaults;

        SlashWithDefault(ArgTy[] plainNames, NameDefaultPair[] namesWithDefaults) {
            this.plainNames = plainNames;
            this.namesWithDefaults = namesWithDefaults;
        }
    }

    public static final class NameDefaultPair {
        final ArgTy name;
        final ExprTy def;

        NameDefaultPair(ArgTy name, ExprTy def) {
            this.name = name;
            this.def = def;
        }
    }

    public static final class CmpopExprPair {
        final CmpOpTy op;
        final ExprTy expr;

        CmpopExprPair(CmpOpTy op, ExprTy expr) {
            this.op = op;
            this.expr = expr;
        }
    }
}

