/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.ermodel.weakassociations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import schemacrawler.ermodel.weakassociations.ExtensionTableMatcher;
import schemacrawler.ermodel.weakassociations.IdMatcher;
import schemacrawler.ermodel.weakassociations.TableMatchKeys;
import schemacrawler.ermodel.weakassociations.WeakAssociationsAnalyzer;
import schemacrawler.schema.ColumnReference;
import schemacrawler.schema.Table;
import us.fatehi.utility.Builder;

public class WeakAssociationsAnalyzerBuilder
implements Builder<WeakAssociationsAnalyzer> {
    private final TableMatchKeys tableMatchKeys;
    private Predicate<ColumnReference> weakAssociationsRule;

    public static WeakAssociationsAnalyzerBuilder builder(Collection<Table> allTables) {
        Objects.requireNonNull(allTables, "No tables provided");
        ArrayList<Table> tables = new ArrayList<Table>(allTables);
        Collections.sort(tables);
        return new WeakAssociationsAnalyzerBuilder(List.copyOf(tables));
    }

    private WeakAssociationsAnalyzerBuilder(List<Table> allTables) {
        this.tableMatchKeys = new TableMatchKeys(allTables);
        this.weakAssociationsRule = colRef -> false;
    }

    @Override
    public WeakAssociationsAnalyzer build() {
        return new WeakAssociationsAnalyzer(this.tableMatchKeys, this.weakAssociationsRule);
    }

    public WeakAssociationsAnalyzerBuilder withExtensionTableMatcher() {
        this.weakAssociationsRule = this.weakAssociationsRule.or(new ExtensionTableMatcher(this.tableMatchKeys));
        return this;
    }

    public WeakAssociationsAnalyzerBuilder withIdMatcher() {
        this.weakAssociationsRule = this.weakAssociationsRule.or(new IdMatcher());
        return this;
    }
}

