/*
 * Decompiled with CFR 0.152.
 */
package dafny;

import dafny.DafnySequence;
import dafny.LazyDafnySequence;
import dafny.NonLazyDafnySequence;
import java.util.ArrayDeque;

final class ConcatDafnySequence<T>
extends LazyDafnySequence<T> {
    private volatile DafnySequence<T> left;
    private volatile DafnySequence<T> right;
    private NonLazyDafnySequence<T> ans = null;
    private final int length;

    ConcatDafnySequence(DafnySequence<T> left, DafnySequence<T> right) {
        this.left = left;
        this.right = right;
        this.length = left.length() + right.length();
    }

    @Override
    protected NonLazyDafnySequence<T> force() {
        if (this.ans == null) {
            this.ans = this.computeElements();
            this.left = null;
            this.right = null;
        }
        return this.ans;
    }

    @Override
    public int length() {
        return this.length;
    }

    private NonLazyDafnySequence<T> computeElements() {
        ArrayDeque<DafnySequence<T>> toVisit = new ArrayDeque<DafnySequence<T>>();
        DafnySequence<T> leftBuffer = this.left;
        DafnySequence<T> rightBuffer = this.right;
        if (leftBuffer == null || rightBuffer == null) {
            return this.ans;
        }
        toVisit.push(rightBuffer);
        DafnySequence<T> first = leftBuffer;
        while (first instanceof ConcatDafnySequence) {
            ConcatDafnySequence cfirst = (ConcatDafnySequence)first;
            leftBuffer = cfirst.left;
            rightBuffer = cfirst.right;
            if (leftBuffer == null || rightBuffer == null) break;
            toVisit.push(rightBuffer);
            first = leftBuffer;
        }
        toVisit.push(first);
        DafnySequence.Copier<T> copier = first.newCopier(this.length);
        while (!toVisit.isEmpty()) {
            DafnySequence seq = (DafnySequence)toVisit.pop();
            if (seq instanceof ConcatDafnySequence) {
                ConcatDafnySequence cseq = (ConcatDafnySequence)seq;
                leftBuffer = cseq.left;
                rightBuffer = cseq.right;
                if (leftBuffer == null || rightBuffer == null) {
                    copier.copyFrom(cseq.ans);
                    continue;
                }
                toVisit.push(rightBuffer);
                toVisit.push(leftBuffer);
                continue;
            }
            copier.copyFrom(seq);
        }
        return copier.result();
    }
}

