/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.engine.tools;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opensearch.core.action.ActionListener;
import org.opensearch.ml.common.spi.tools.Tool;
import org.opensearch.ml.common.spi.tools.ToolAnnotation;
import org.opensearch.ml.common.utils.StringUtils;

@ToolAnnotation(value="WriteToScratchPadTool")
public class WriteToScratchPadTool
implements Tool {
    public static final String TYPE = "WriteToScratchPadTool";
    public static final String SCRATCHPAD_NOTES_KEY = "_scratchpad_notes";
    public static final String NOTES_KEY = "notes";
    public static final String RETURN_HISTORY_KEY = "return_history";
    public static final String STRICT_FIELD = "strict";
    private static final String DEFAULT_DESCRIPTION = "Save research plans, findings, and progress updates to a persistent scratchpad.";
    public static final String DEFAULT_INPUT_SCHEMA = "{\"type\":\"object\",\"properties\":{\"notes\":{\"type\":\"string\",\"description\":\"The notes to be saved to the scratchpad.\"}},\"required\":[\"notes\"]}";
    private String name = "WriteToScratchPadTool";
    private String description = "Save research plans, findings, and progress updates to a persistent scratchpad.";
    private Map<String, Object> attributes = new HashMap<String, Object>();

    public WriteToScratchPadTool() {
        this.attributes.put("input_schema", DEFAULT_INPUT_SCHEMA);
        this.attributes.put(STRICT_FIELD, true);
    }

    public String getType() {
        return TYPE;
    }

    public String getVersion() {
        return "1";
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean validate(Map<String, String> parameters) {
        return parameters != null && parameters.containsKey(NOTES_KEY);
    }

    public <T> void run(Map<String, String> parameters, ActionListener<T> listener) {
        List parsedNotes;
        boolean returnHistory;
        String currentNote = parameters.get(NOTES_KEY);
        boolean bl = returnHistory = parameters.containsKey(RETURN_HISTORY_KEY) && Boolean.parseBoolean(parameters.get(RETURN_HISTORY_KEY));
        if (currentNote == null || currentNote.isEmpty()) {
            listener.onFailure((Exception)new IllegalArgumentException("Parameter 'notes' is required for WriteToScratchPadTool."));
            return;
        }
        Map<String, String> rawParameters = parameters;
        String existingNotes = rawParameters.get(SCRATCHPAD_NOTES_KEY);
        ArrayList<String> notes = existingNotes instanceof List ? new ArrayList<String>((List)((Object)existingNotes)) : (existingNotes instanceof String ? ((parsedNotes = StringUtils.parseStringArrayToList((String)existingNotes)) != null ? new ArrayList(parsedNotes) : new ArrayList()) : new ArrayList());
        notes.add(currentNote);
        rawParameters.put(SCRATCHPAD_NOTES_KEY, (String)((Object)notes));
        if (returnHistory) {
            String fullNotesFormatted = "- " + String.join((CharSequence)"\n- ", notes);
            listener.onResponse((Object)("Scratchpad updated. Full content:\n" + fullNotesFormatted));
        } else {
            listener.onResponse((Object)("Wrote to scratchpad: " + currentNote));
        }
    }

    public static class Factory
    implements Tool.Factory<WriteToScratchPadTool> {
        private static Factory INSTANCE;

        public static Factory getInstance() {
            if (INSTANCE == null) {
                INSTANCE = new Factory();
            }
            return INSTANCE;
        }

        public void init() {
        }

        public WriteToScratchPadTool create(Map<String, Object> params) {
            return new WriteToScratchPadTool();
        }

        public String getDefaultDescription() {
            return WriteToScratchPadTool.DEFAULT_DESCRIPTION;
        }

        public String getDefaultType() {
            return WriteToScratchPadTool.TYPE;
        }

        public String getDefaultVersion() {
            return "1";
        }

        public Map<String, Object> getDefaultAttributes() {
            return Map.of("input_schema", WriteToScratchPadTool.DEFAULT_INPUT_SCHEMA, WriteToScratchPadTool.STRICT_FIELD, true);
        }
    }
}

