/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.transport;

import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.ValidateActions;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.timeseries.AnalysisType;
import org.opensearch.timeseries.model.Entity;

public class EntityResultRequest
extends ActionRequest
implements ToXContentObject {
    protected String configId;
    protected Map<Entity, double[]> entities;
    protected long start;
    protected long end;
    protected AnalysisType analysisType;
    protected String taskId;

    public EntityResultRequest(StreamInput in) throws IOException {
        super(in);
        this.configId = in.readString();
        this.entities = in.readMap(Entity::new, StreamInput::readDoubleArray);
        this.start = in.readLong();
        this.end = in.readLong();
        if (in.available() > 0) {
            this.analysisType = (AnalysisType)in.readEnum(AnalysisType.class);
            this.taskId = in.readOptionalString();
        }
    }

    public EntityResultRequest(String configId, Map<Entity, double[]> entities, long start, long end, AnalysisType analysisType, String taskId) {
        this.configId = configId;
        this.entities = entities;
        this.start = start;
        this.end = end;
        this.analysisType = analysisType;
        this.taskId = taskId;
    }

    public String getConfigId() {
        return this.configId;
    }

    public Map<Entity, double[]> getEntities() {
        return this.entities;
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        return this.end;
    }

    public AnalysisType getAnalysisType() {
        return this.analysisType;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.configId);
        out.writeMap(this.entities, (s, e) -> e.writeTo(s), StreamOutput::writeDoubleArray);
        out.writeLong(this.start);
        out.writeLong(this.end);
        out.writeEnum((Enum)this.analysisType);
        out.writeOptionalString(this.taskId);
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (Strings.isEmpty((CharSequence)this.configId)) {
            validationException = ValidateActions.addValidationError((String)"config ID is missing", validationException);
        }
        if (this.start <= 0L || this.end <= 0L || this.start > this.end) {
            validationException = ValidateActions.addValidationError((String)String.format(Locale.ROOT, "%s: start %d, end %d", "timestamp is invalid", this.start, this.end), (ActionRequestValidationException)validationException);
        }
        return validationException;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("config_id", this.configId);
        builder.field("start", this.start);
        builder.field("end", this.end);
        builder.startArray("entities");
        for (Map.Entry<Entity, double[]> entry : this.entities.entrySet()) {
            if (entry.getKey() == null) continue;
            builder.startObject();
            builder.field("entity", (ToXContent)entry.getKey());
            builder.field("value", (Object)entry.getValue());
            builder.endObject();
        }
        builder.endArray();
        builder.field("analysis_type", (Object)this.analysisType);
        builder.field("task_id", this.taskId);
        builder.endObject();
        return builder;
    }
}

