/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.impl;

import com.thaiopensource.relaxng.impl.AbstractPatternFunction;
import com.thaiopensource.relaxng.impl.ChoicePattern;
import com.thaiopensource.relaxng.impl.ElementPattern;
import com.thaiopensource.relaxng.impl.GroupPattern;
import com.thaiopensource.relaxng.impl.InterleavePattern;
import com.thaiopensource.relaxng.impl.OneOrMorePattern;
import com.thaiopensource.relaxng.impl.Pattern;
import com.thaiopensource.relaxng.impl.SchemaPatternBuilder;
import java.util.Hashtable;

public class FeasibleTransform {
    public static Pattern transform(SchemaPatternBuilder schemaPatternBuilder, Pattern pattern) {
        return pattern.applyForPattern(new FeasiblePatternFunction(schemaPatternBuilder));
    }

    private static class FeasiblePatternFunction
    extends AbstractPatternFunction {
        private final SchemaPatternBuilder spb;
        private final Hashtable elementTable = new Hashtable();

        FeasiblePatternFunction(SchemaPatternBuilder schemaPatternBuilder) {
            this.spb = schemaPatternBuilder;
        }

        public Object caseChoice(ChoicePattern choicePattern) {
            return this.spb.makeChoice(choicePattern.getOperand1().applyForPattern(this), choicePattern.getOperand2().applyForPattern(this));
        }

        public Object caseGroup(GroupPattern groupPattern) {
            return this.spb.makeGroup(groupPattern.getOperand1().applyForPattern(this), groupPattern.getOperand2().applyForPattern(this));
        }

        public Object caseInterleave(InterleavePattern interleavePattern) {
            return this.spb.makeInterleave(interleavePattern.getOperand1().applyForPattern(this), interleavePattern.getOperand2().applyForPattern(this));
        }

        public Object caseOneOrMore(OneOrMorePattern oneOrMorePattern) {
            return this.spb.makeOneOrMore(oneOrMorePattern.getOperand().applyForPattern(this));
        }

        public Object caseElement(ElementPattern elementPattern) {
            if (this.elementTable.get(elementPattern) == null) {
                this.elementTable.put(elementPattern, elementPattern);
                elementPattern.setContent(elementPattern.getContent().applyForPattern(this));
            }
            return this.spb.makeOptional(elementPattern);
        }

        public Object caseOther(Pattern pattern) {
            return this.spb.makeOptional(pattern);
        }
    }
}

