/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java.components;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtilKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.FilePreprocessorExtension;
import org.jetbrains.kotlin.resolve.FilePreprocessorKt;
import org.jetbrains.kotlin.util.slicedMap.BasicWritableSlice;
import org.jetbrains.kotlin.util.slicedMap.Slices;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/load/java/components/FilesByFacadeFqNameIndexer;", "Lorg/jetbrains/kotlin/resolve/FilePreprocessorExtension;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "<init>", "(Lorg/jetbrains/kotlin/resolve/BindingTrace;)V", "preprocessFile", "", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "Companion", "frontend.java"})
public final class FilesByFacadeFqNameIndexer
implements FilePreprocessorExtension {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BindingTrace trace;
    @JvmField
    @NotNull
    public static final WritableSlice<FqName, Collection<KtFile>> FACADE_FILES_BY_FQ_NAME;
    @JvmField
    @NotNull
    public static final WritableSlice<FqName, Collection<KtFile>> FACADE_FILES_BY_PACKAGE_NAME;

    public FilesByFacadeFqNameIndexer(@NotNull BindingTrace trace) {
        Intrinsics.checkNotNullParameter(trace, "trace");
        this.trace = trace;
    }

    @Override
    public void preprocessFile(@NotNull KtFile file2) {
        Intrinsics.checkNotNullParameter(file2, "file");
        if (!file2.hasTopLevelCallables()) {
            return;
        }
        FilePreprocessorKt.addElementToSlice(this.trace, FACADE_FILES_BY_FQ_NAME, JvmFileClassUtilKt.getJavaFileFacadeFqName(file2), file2);
        FilePreprocessorKt.addElementToSlice(this.trace, FACADE_FILES_BY_PACKAGE_NAME, JvmFileClassUtilKt.getJavaFileFacadeFqName(file2).parent(), file2);
    }

    static {
        WritableSlice writableSlice = Slices.createSimpleSlice();
        Intrinsics.checkNotNullExpressionValue(writableSlice, "createSimpleSlice(...)");
        FACADE_FILES_BY_FQ_NAME = writableSlice;
        WritableSlice writableSlice2 = Slices.createSimpleSlice();
        Intrinsics.checkNotNullExpressionValue(writableSlice2, "createSimpleSlice(...)");
        FACADE_FILES_BY_PACKAGE_NAME = writableSlice2;
        BasicWritableSlice.initSliceDebugNames(FilesByFacadeFqNameIndexer.class);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\"\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/load/java/components/FilesByFacadeFqNameIndexer$Companion;", "", "<init>", "()V", "FACADE_FILES_BY_FQ_NAME", "Lorg/jetbrains/kotlin/util/slicedMap/WritableSlice;", "Lorg/jetbrains/kotlin/name/FqName;", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "FACADE_FILES_BY_PACKAGE_NAME", "frontend.java"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

