/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.DataGridBundle;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridPanel;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.extractors.ImageInfo;
import com.intellij.database.run.ui.EditMaximizedView;
import com.intellij.database.run.ui.EditMaximizedViewKt;
import com.intellij.database.run.ui.EditorCellViewer;
import com.intellij.database.run.ui.TabInfoProvider;
import com.intellij.database.run.ui.ValueTabInfoProvider;
import com.intellij.database.util.DataGridUIUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ObjectUtils;
import javax.swing.JComponent;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;

public class ShowEditMaximizedAction
extends DumbAwareAction {
    private static final String EDIT_MAXIMIZED_POSITION = "EditMaximizedView.POSITION";

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ShowEditMaximizedAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        DataGrid grid;
        if (e == null) {
            ShowEditMaximizedAction.$$$reportNull$$$0(1);
        }
        if ((grid = GridUtil.getDataGrid(e.getDataContext())) == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        boolean inCell = DataGridUIUtil.inCell(grid, e);
        if (inCell) {
            Object value = DataGridUIUtil.getLeadSelectionCellValue(grid, e, false);
            e.getPresentation().setText(value instanceof ImageInfo ? DataGridBundle.message((String)"action.Console.TableResult.EditValueMaximized.view.image", (Object[])new Object[0]) : DataGridBundle.message((String)"action.Console.TableResult.EditValueMaximized.maximize", (Object[])new Object[0]));
        } else {
            e.getPresentation().setText(DataGridBundle.message((String)"action.Console.TableResult.EditValueMaximized.text", (Object[])new Object[0]));
        }
        EditMaximizedView editMaximized = EditMaximizedViewKt.findEditMaximized(e.getDataContext());
        boolean visible = editMaximized != null && editMaximized.getCurrentTabInfoProvider() instanceof ValueTabInfoProvider;
        e.getPresentation().setEnabledAndVisible(inCell || !visible);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        DataGrid grid;
        if (e == null) {
            ShowEditMaximizedAction.$$$reportNull$$$0(2);
        }
        if ((grid = GridUtil.getDataGrid(e.getDataContext())) == null) {
            return;
        }
        EditMaximizedView view = ShowEditMaximizedAction.getView(grid, e);
        view.open((Function1<? super TabInfoProvider, Boolean>)((Function1)tabInfoProvider -> tabInfoProvider instanceof ValueTabInfoProvider));
        if (grid.isEditable()) {
            EditorCellViewer cellViewer;
            JComponent focusComponent = view.getPreferedFocusComponent();
            if (focusComponent != null) {
                focusComponent.requestFocus();
            }
            if ((cellViewer = (EditorCellViewer)ObjectUtils.tryCast((Object)view.getCurrentTabInfoProvider().getViewer(), EditorCellViewer.class)) != null) {
                cellViewer.selectAll();
            }
        }
    }

    public static EditMaximizedView getView(@NotNull DataGrid grid, @NotNull AnActionEvent e) {
        EditMaximizedView view;
        if (grid == null) {
            ShowEditMaximizedAction.$$$reportNull$$$0(3);
        }
        if (e == null) {
            ShowEditMaximizedAction.$$$reportNull$$$0(4);
        }
        if ((view = EditMaximizedViewKt.findEditMaximized(e.getDataContext())) == null) {
            view = new EditMaximizedView(grid);
            Disposer.register((Disposable)grid, (Disposable)view);
            grid.getPanel().putSideView(view, ShowEditMaximizedAction.getPosition(), null);
        }
        return view;
    }

    public static void savePosition(@NotNull GridPanel.ViewPosition position) {
        if (position == null) {
            ShowEditMaximizedAction.$$$reportNull$$$0(5);
        }
        PropertiesComponent.getInstance().setValue(EDIT_MAXIMIZED_POSITION, position.name());
    }

    public static boolean someViewIsShown(@NotNull DataGrid grid) {
        GridPanel panel2;
        if (grid == null) {
            ShowEditMaximizedAction.$$$reportNull$$$0(6);
        }
        return (panel2 = grid.getPanel()).getSideView(GridPanel.ViewPosition.RIGHT) != null || panel2.getSideView(GridPanel.ViewPosition.BOTTOM) != null;
    }

    @NotNull
    public static GridPanel.ViewPosition getPosition() {
        String name;
        block6: {
            GridPanel.ViewPosition viewPosition;
            try {
                name = PropertiesComponent.getInstance().getValue(EDIT_MAXIMIZED_POSITION);
                if (name != null) break block6;
                viewPosition = GridPanel.ViewPosition.RIGHT;
            }
            catch (IllegalArgumentException e) {
                GridPanel.ViewPosition viewPosition2 = GridPanel.ViewPosition.RIGHT;
                if (viewPosition2 == null) {
                    ShowEditMaximizedAction.$$$reportNull$$$0(9);
                }
                return viewPosition2;
            }
            if (viewPosition == null) {
                ShowEditMaximizedAction.$$$reportNull$$$0(7);
            }
            return viewPosition;
        }
        GridPanel.ViewPosition viewPosition = GridPanel.ViewPosition.valueOf(name);
        if (viewPosition == null) {
            ShowEditMaximizedAction.$$$reportNull$$$0(8);
        }
        return viewPosition;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/actions/ShowEditMaximizedAction";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/actions/ShowEditMaximizedAction";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPosition";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getView";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "savePosition";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "someViewIsShown";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6 -> new IllegalArgumentException(string);
        };
    }
}

