/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.declarations.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.fir.declarations.DirectDeclarationsAccess;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousInitializer;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirErrorPrimaryConstructor;
import org.jetbrains.kotlin.fir.declarations.FirField;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.expressions.FirComponentCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirPropertyAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.FirLazyDeclarationResolverKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbolKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFileSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0094\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u00100\u001a\u0004\u0018\u00010-*\u0006\u0012\u0002\b\u00030 2\u0006\u00101\u001a\u000202\u001a\n\u00109\u001a\u00020\u0019*\u00020:\u001a\f\u0010;\u001a\u0004\u0018\u00010<*\u00020=\u001a\u0010\u0010>\u001a\b\u0012\u0004\u0012\u00020?0\u000b*\u00020#\"\u0017\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0005\u001a\u00020\u0006*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\"\u001b\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00010\u000b*\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\"!\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u000b*\u00020\f8F\u00a2\u0006\f\u0012\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u0013\u0010\u000e\"$\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u000b*\u00020\f8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0016\u0010\u0012\u001a\u0004\b\u0017\u0010\u000e\"\u0016\u0010\u0018\u001a\u00020\u0019*\u00020\u001a8\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u001b\"\u0016\u0010\u001c\u001a\u00020\u0019*\u00020\u001a8\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001b\"\u0016\u0010\u001d\u001a\u00020\u0019*\u00020\u001a8\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001b\"\u0016\u0010\u001e\u001a\u00020\u0019*\u00020\u001a8\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001b\"\u0015\u0010\u001f\u001a\u00020\u0019*\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u001b\"\u0019\u0010\u001f\u001a\u00020\u0019*\u0006\u0012\u0002\b\u00030 8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010!\"\u0015\u0010\"\u001a\u00020\u0019*\u00020#8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010$\"\u0019\u0010\"\u001a\u00020\u0019*\u0006\u0012\u0002\b\u00030%8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010&\"\u0019\u0010'\u001a\u00020\u0019*\u0006\u0012\u0002\b\u00030 8F\u00a2\u0006\u0006\u001a\u0004\b'\u0010!\"\u001b\u0010(\u001a\u0004\u0018\u00010)*\u0006\u0012\u0002\b\u00030 8F\u00a2\u0006\u0006\u001a\u0004\b*\u0010+\"\u0015\u0010,\u001a\u00020)*\u00020-8F\u00a2\u0006\u0006\u001a\u0004\b.\u0010/\"\u0015\u00103\u001a\u00020\u0019*\u0002048F\u00a2\u0006\u0006\u001a\u0004\b3\u00105\"\u0015\u00106\u001a\u00020\u0019*\u0002078F\u00a2\u0006\u0006\u001a\u0004\b6\u00108\u00a8\u0006@"}, d2={"expandedConeType", "Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;", "getExpandedConeType", "(Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;)Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;", "getClassId", "(Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;)Lorg/jetbrains/kotlin/name/ClassId;", "superConeTypes", "", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "getSuperConeTypes", "(Lorg/jetbrains/kotlin/fir/declarations/FirClass;)Ljava/util/List;", "anonymousInitializers", "Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousInitializer;", "getAnonymousInitializers$annotations", "(Lorg/jetbrains/kotlin/fir/declarations/FirClass;)V", "getAnonymousInitializers", "delegateFields", "Lorg/jetbrains/kotlin/fir/declarations/FirField;", "getDelegateFields$annotations", "getDelegateFields", "isJava", "", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "(Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;)Z", "isFromLibrary", "isPrecompiled", "isSynthetic", "isNonLocal", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "(Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;)Z", "isExtension", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "(Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;)Z", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;)Z", "isMemberDeclaration", "memberDeclarationNameOrNull", "Lorg/jetbrains/kotlin/name/Name;", "getMemberDeclarationNameOrNull", "(Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;)Lorg/jetbrains/kotlin/name/Name;", "nameOrSpecialName", "Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "getNameOrSpecialName", "(Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;)Lorg/jetbrains/kotlin/name/Name;", "asMemberDeclarationResolvedTo", "phase", "Lorg/jetbrains/kotlin/fir/declarations/FirResolvePhase;", "isMethodOfAny", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;)Z", "isErrorPrimaryConstructor", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirConstructorSymbol;", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirConstructorSymbol;)Z", "isDestructuredParameter", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "getDestructuredParameter", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirValueParameterSymbol;", "Lorg/jetbrains/kotlin/fir/declarations/FirVariable;", "contextParametersForFunctionOrContainingProperty", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "tree"})
@SourceDebugExtension(value={"SMAP\nFirDeclarationUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirDeclarationUtil.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirDeclarationUtilKt\n+ 2 FirTypeUtils.kt\norg/jetbrains/kotlin/fir/types/FirTypeUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,119:1\n52#1:159\n28#2:120\n28#2:131\n1617#3,9:121\n1869#3:130\n1870#3:133\n1626#3:134\n808#3,11:135\n808#3,11:146\n774#3:157\n865#3:158\n866#3:160\n1#4:132\n*S KotlinDebug\n*F\n+ 1 FirDeclarationUtil.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirDeclarationUtilKt\n*L\n43#1:159\n30#1:120\n35#1:131\n35#1:121,9\n35#1:130\n35#1:133\n35#1:134\n39#1:135,11\n43#1:146,11\n43#1:157\n43#1:158\n43#1:160\n35#1:132\n*E\n"})
public final class FirDeclarationUtilKt {
    @Nullable
    public static final ConeClassLikeType getExpandedConeType(@NotNull FirTypeAlias $this$expandedConeType) {
        Intrinsics.checkNotNullParameter($this$expandedConeType, "<this>");
        FirTypeRef $this$coneTypeSafe$iv = $this$expandedConeType.getExpandedTypeRef();
        boolean $i$f$coneTypeSafe = false;
        FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
        ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getConeType() : null;
        if (!(coneKotlinType instanceof ConeClassLikeType)) {
            coneKotlinType = null;
        }
        return (ConeClassLikeType)((ConeKotlinType)((ConeClassLikeType)coneKotlinType));
    }

    @NotNull
    public static final ClassId getClassId(@NotNull FirClassLikeDeclaration $this$classId) {
        Intrinsics.checkNotNullParameter($this$classId, "<this>");
        return $this$classId.getSymbol().getClassId();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ConeClassLikeType> getSuperConeTypes(@NotNull FirClass $this$superConeTypes) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$superConeTypes, "<this>");
        Iterable $this$mapNotNull$iv = $this$superConeTypes.getSuperTypeRefs();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            ConeClassLikeType it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            FirTypeRef it = (FirTypeRef)element$iv$iv;
            boolean bl2 = false;
            FirTypeRef $this$coneTypeSafe$iv = it;
            boolean $i$f$coneTypeSafe = false;
            FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
            ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getConeType() : null;
            if (!(coneKotlinType instanceof ConeClassLikeType)) {
                coneKotlinType = null;
            }
            if ((ConeClassLikeType)((ConeKotlinType)((ConeClassLikeType)coneKotlinType)) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<FirAnonymousInitializer> getAnonymousInitializers(@NotNull FirClass $this$anonymousInitializers) {
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$anonymousInitializers, "<this>");
        Iterable $this$filterIsInstance$iv = $this$anonymousInitializers.getDeclarations();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof FirAnonymousInitializer)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ void getAnonymousInitializers$annotations(FirClass firClass) {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<FirField> getDelegateFields(@NotNull FirClass $this$delegateFields) {
        void $this$filterTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$delegateFields, "<this>");
        Iterable $this$filterIsInstance$iv = $this$delegateFields.getDeclarations();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof FirField)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            FirField it = (FirField)element$iv$iv;
            boolean bl = false;
            FirDeclaration $this$isSynthetic$iv = it;
            boolean $i$f$isSynthetic = false;
            if (!($this$isSynthetic$iv.getOrigin() instanceof FirDeclarationOrigin.Synthetic)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @DirectDeclarationsAccess
    public static /* synthetic */ void getDelegateFields$annotations(FirClass firClass) {
    }

    public static final boolean isJava(@NotNull FirDeclaration $this$isJava) {
        Intrinsics.checkNotNullParameter($this$isJava, "<this>");
        boolean $i$f$isJava = false;
        return $this$isJava.getOrigin() instanceof FirDeclarationOrigin.Java;
    }

    public static final boolean isFromLibrary(@NotNull FirDeclaration $this$isFromLibrary) {
        Intrinsics.checkNotNullParameter($this$isFromLibrary, "<this>");
        boolean $i$f$isFromLibrary = false;
        return Intrinsics.areEqual($this$isFromLibrary.getOrigin(), FirDeclarationOrigin.Library.INSTANCE) || Intrinsics.areEqual($this$isFromLibrary.getOrigin(), FirDeclarationOrigin.Java.Library.INSTANCE);
    }

    public static final boolean isPrecompiled(@NotNull FirDeclaration $this$isPrecompiled) {
        Intrinsics.checkNotNullParameter($this$isPrecompiled, "<this>");
        boolean $i$f$isPrecompiled = false;
        return Intrinsics.areEqual($this$isPrecompiled.getOrigin(), FirDeclarationOrigin.Precompiled.INSTANCE);
    }

    public static final boolean isSynthetic(@NotNull FirDeclaration $this$isSynthetic) {
        Intrinsics.checkNotNullParameter($this$isSynthetic, "<this>");
        boolean $i$f$isSynthetic = false;
        return $this$isSynthetic.getOrigin() instanceof FirDeclarationOrigin.Synthetic;
    }

    public static final boolean isNonLocal(@NotNull FirDeclaration $this$isNonLocal) {
        Intrinsics.checkNotNullParameter($this$isNonLocal, "<this>");
        return FirDeclarationUtilKt.isNonLocal($this$isNonLocal.getSymbol());
    }

    public static final boolean isNonLocal(@NotNull FirBasedSymbol<?> $this$isNonLocal) {
        Intrinsics.checkNotNullParameter($this$isNonLocal, "<this>");
        FirBasedSymbol<?> firBasedSymbol = $this$isNonLocal;
        return firBasedSymbol instanceof FirFileSymbol ? true : (firBasedSymbol instanceof FirCallableSymbol ? !((FirCallableSymbol)$this$isNonLocal).getCallableId().isLocal() : (firBasedSymbol instanceof FirClassLikeSymbol ? !((FirClassLikeSymbol)$this$isNonLocal).getClassId().isLocal() : false));
    }

    public static final boolean isExtension(@NotNull FirCallableDeclaration $this$isExtension) {
        Intrinsics.checkNotNullParameter($this$isExtension, "<this>");
        return $this$isExtension.getReceiverParameter() != null;
    }

    public static final boolean isExtension(@NotNull FirCallableSymbol<?> $this$isExtension) {
        Intrinsics.checkNotNullParameter($this$isExtension, "<this>");
        return FirDeclarationUtilKt.isExtension((FirCallableDeclaration)$this$isExtension.getFir());
    }

    public static final boolean isMemberDeclaration(@NotNull FirBasedSymbol<?> $this$isMemberDeclaration) {
        Intrinsics.checkNotNullParameter($this$isMemberDeclaration, "<this>");
        return $this$isMemberDeclaration.getFir() instanceof FirMemberDeclaration;
    }

    @Nullable
    public static final Name getMemberDeclarationNameOrNull(@NotNull FirBasedSymbol<?> $this$memberDeclarationNameOrNull) {
        Intrinsics.checkNotNullParameter($this$memberDeclarationNameOrNull, "<this>");
        Object obj = $this$memberDeclarationNameOrNull.getFir();
        FirMemberDeclaration firMemberDeclaration = obj instanceof FirMemberDeclaration ? (FirMemberDeclaration)obj : null;
        return firMemberDeclaration != null ? FirDeclarationUtilKt.getNameOrSpecialName(firMemberDeclaration) : null;
    }

    @NotNull
    public static final Name getNameOrSpecialName(@NotNull FirMemberDeclaration $this$nameOrSpecialName) {
        Name name2;
        Intrinsics.checkNotNullParameter($this$nameOrSpecialName, "<this>");
        FirMemberDeclaration firMemberDeclaration = $this$nameOrSpecialName;
        if (firMemberDeclaration instanceof FirCallableDeclaration) {
            name2 = ((FirCallableDeclaration)$this$nameOrSpecialName).getSymbol().getCallableId().getCallableName();
        } else if (firMemberDeclaration instanceof FirClassLikeDeclaration) {
            name2 = FirDeclarationUtilKt.getClassId((FirClassLikeDeclaration)$this$nameOrSpecialName).getShortClassName();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return name2;
    }

    @Nullable
    public static final FirMemberDeclaration asMemberDeclarationResolvedTo(@NotNull FirBasedSymbol<?> $this$asMemberDeclarationResolvedTo, @NotNull FirResolvePhase phase) {
        FirMemberDeclaration firMemberDeclaration;
        Intrinsics.checkNotNullParameter($this$asMemberDeclarationResolvedTo, "<this>");
        Intrinsics.checkNotNullParameter((Object)phase, "phase");
        Object object = $this$asMemberDeclarationResolvedTo.getFir();
        FirMemberDeclaration firMemberDeclaration2 = object instanceof FirMemberDeclaration ? (FirMemberDeclaration)object : null;
        if (firMemberDeclaration2 != null) {
            Object it = object = firMemberDeclaration2;
            boolean bl = false;
            FirLazyDeclarationResolverKt.lazyResolveToPhase($this$asMemberDeclarationResolvedTo, phase);
            firMemberDeclaration = (FirMemberDeclaration)object;
        } else {
            firMemberDeclaration = null;
        }
        return firMemberDeclaration;
    }

    public static final boolean isMethodOfAny(@NotNull FirNamedFunctionSymbol $this$isMethodOfAny) {
        Object object;
        Intrinsics.checkNotNullParameter($this$isMethodOfAny, "<this>");
        if (FirDeclarationUtilKt.isExtension($this$isMethodOfAny) || FirCallableSymbolKt.getHasContextParameters($this$isMethodOfAny)) {
            return false;
        }
        Name name2 = $this$isMethodOfAny.getName();
        return Intrinsics.areEqual(name2, OperatorNameConventions.EQUALS) ? ((object = CollectionsKt.singleOrNull($this$isMethodOfAny.getValueParameterSymbols())) != null && (object = ((FirCallableSymbol)object).getResolvedReturnType()) != null ? ConeBuiltinTypeUtilsKt.isNullableAny((ConeKotlinType)object) : false) : (Intrinsics.areEqual(name2, OperatorNameConventions.HASH_CODE) || Intrinsics.areEqual(name2, OperatorNameConventions.TO_STRING) ? ((FirSimpleFunction)$this$isMethodOfAny.getFir()).getValueParameters().isEmpty() : false);
    }

    public static final boolean isErrorPrimaryConstructor(@NotNull FirConstructorSymbol $this$isErrorPrimaryConstructor) {
        Intrinsics.checkNotNullParameter($this$isErrorPrimaryConstructor, "<this>");
        return $this$isErrorPrimaryConstructor.getFir() instanceof FirErrorPrimaryConstructor;
    }

    public static final boolean isDestructuredParameter(@NotNull FirStatement $this$isDestructuredParameter) {
        Intrinsics.checkNotNullParameter($this$isDestructuredParameter, "<this>");
        return $this$isDestructuredParameter instanceof FirVariable && FirDeclarationUtilKt.getDestructuredParameter((FirVariable)$this$isDestructuredParameter) != null;
    }

    @Nullable
    public static final FirValueParameterSymbol getDestructuredParameter(@NotNull FirVariable $this$getDestructuredParameter) {
        Intrinsics.checkNotNullParameter($this$getDestructuredParameter, "<this>");
        FirExpression initializer = $this$getDestructuredParameter.getInitializer();
        if (!(initializer instanceof FirComponentCall)) {
            return null;
        }
        KtSourceElement ktSourceElement = ((FirComponentCall)initializer).getSource();
        if (!((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind.DesugaredComponentFunctionCall)) {
            return null;
        }
        FirExpression firExpression = ((FirComponentCall)initializer).getDispatchReceiver();
        if (firExpression == null && (firExpression = ((FirComponentCall)initializer).getExtensionReceiver()) == null) {
            return null;
        }
        FirExpression receiver = firExpression;
        if (!(receiver instanceof FirPropertyAccessExpression)) {
            return null;
        }
        FirNamedReference firNamedReference = ((FirPropertyAccessExpression)receiver).getCalleeReference();
        FirResolvedNamedReference firResolvedNamedReference = firNamedReference instanceof FirResolvedNamedReference ? (FirResolvedNamedReference)firNamedReference : null;
        if (firResolvedNamedReference == null) {
            return null;
        }
        FirResolvedNamedReference calleeReference = firResolvedNamedReference;
        FirBasedSymbol<?> firBasedSymbol = calleeReference.getResolvedSymbol();
        return firBasedSymbol instanceof FirValueParameterSymbol ? (FirValueParameterSymbol)firBasedSymbol : null;
    }

    @NotNull
    public static final List<FirValueParameter> contextParametersForFunctionOrContainingProperty(@NotNull FirCallableDeclaration $this$contextParametersForFunctionOrContainingProperty) {
        Intrinsics.checkNotNullParameter($this$contextParametersForFunctionOrContainingProperty, "<this>");
        return $this$contextParametersForFunctionOrContainingProperty instanceof FirPropertyAccessor ? ((FirProperty)((FirPropertyAccessor)$this$contextParametersForFunctionOrContainingProperty).getPropertySymbol().getFir()).getContextParameters() : $this$contextParametersForFunctionOrContainingProperty.getContextParameters();
    }
}

