/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.backend.jvm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.jvm.JvmIrAttributesKt;
import org.jetbrains.kotlin.codegen.ClassBuilderMode;
import org.jetbrains.kotlin.codegen.serialization.JvmSerializationBindings;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.config.JvmDefaultMode;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.constant.KClassValue;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.fir.FirAnnotationContainer;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.backend.ConstValueProviderImpl;
import org.jetbrains.kotlin.fir.backend.Fir2IrComponents;
import org.jetbrains.kotlin.fir.backend.jvm.FirJvmSignatureSerializer;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirBackingField;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirReceiverParameter;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirReplSnippet;
import org.jetbrains.kotlin.fir.declarations.FirScript;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.java.JavaUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderKt;
import org.jetbrains.kotlin.fir.serialization.FirAdditionalMetadataProvider;
import org.jetbrains.kotlin.fir.serialization.FirElementAwareStringTable;
import org.jetbrains.kotlin.fir.serialization.FirElementSerializer;
import org.jetbrains.kotlin.fir.serialization.FirSerializerExtension;
import org.jetbrains.kotlin.fir.serialization.LocalClassIdOracle;
import org.jetbrains.kotlin.fir.serialization.SerializationUtilKt;
import org.jetbrains.kotlin.fir.serialization.constant.ConstValueProvider;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeRawType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FunctionalTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitBuiltinTypeRef;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.BinaryVersion;
import org.jetbrains.kotlin.metadata.jvm.JvmProtoBuf;
import org.jetbrains.kotlin.metadata.jvm.deserialization.JvmFlags;
import org.jetbrains.kotlin.metadata.serialization.MutableVersionRequirementTable;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.JvmStandardClassIds;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.serialization.DescriptorSerializer;
import org.jetbrains.kotlin.types.AbstractTypeApproximator;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.Method;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00d6\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u008e\u00012\u00020\u0001:\u0002\u008e\u0001B\u0089\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\u0005\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\r\u0012\u0006\u0010\u0013\u001a\u00020\r\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u0012\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b\u0012\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d\u00a2\u0006\u0004\b\u001e\u0010\u001fBG\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010 \u001a\u00020!\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\"\u001a\u00020#\u0012\u0006\u0010$\u001a\u00020%\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\u0004\b\u001e\u0010&J\b\u00109\u001a\u00020\rH\u0016J(\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020EH\u0016J\u0010\u0010F\u001a\u00020\r2\u0006\u0010>\u001a\u00020GH\u0002J(\u0010H\u001a\u00020=2\u0006\u0010I\u001a\u00020J2\u0006\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020EH\u0016J(\u0010K\u001a\u00020=2\u0006\u0010L\u001a\u00020M2\u0006\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020EH\u0016J\u0018\u0010N\u001a\u00020=2\u0006\u0010@\u001a\u00020A2\u0006\u0010D\u001a\u00020EH\u0002J \u0010O\u001a\u00020=2\u0006\u0010>\u001a\u00020?2\u0006\u0010P\u001a\u00020A2\u0006\u0010B\u001a\u00020CH\u0002J*\u0010Q\u001a\u00020=2\u0006\u0010R\u001a\u00020S2\u0006\u0010@\u001a\u00020T2\b\u0010B\u001a\u0004\u0018\u00010C2\u0006\u0010D\u001a\u00020EH\u0016J \u0010U\u001a\u00020=2\u0006\u0010V\u001a\u00020W2\u0006\u0010X\u001a\u00020Y2\u0006\u0010Z\u001a\u00020YH\u0016J\u001e\u0010[\u001a\u00020=2\f\u0010\\\u001a\b\u0012\u0004\u0012\u00020]0\u00072\u0006\u0010@\u001a\u00020YH\u0016J\u0018\u0010^\u001a\u00020=2\u0006\u0010_\u001a\u00020`2\u0006\u0010@\u001a\u00020aH\u0016J \u0010b\u001a\u00020=2\u0006\u0010c\u001a\u00020d2\u0006\u0010@\u001a\u00020e2\u0006\u0010D\u001a\u00020EH\u0016J*\u0010f\u001a\u00020=2\u0006\u0010g\u001a\u00020h2\u0006\u0010@\u001a\u00020i2\b\u0010B\u001a\u0004\u0018\u00010C2\u0006\u0010D\u001a\u00020EH\u0016J \u0010j\u001a\u00020=*\u00020C2\u0012\u0010k\u001a\u000e\u0012\u0004\u0012\u00020m\u0012\u0004\u0012\u00020=0lH\u0002J\f\u0010n\u001a\u00020\r*\u00020hH\u0002J*\u0010o\u001a\u00020=2\u0006\u0010p\u001a\u00020\b2\u0006\u0010@\u001a\u00020q2\b\u0010B\u001a\u0004\u0018\u00010C2\u0006\u0010D\u001a\u00020EH\u0016J\f\u0010r\u001a\u00020\r*\u00020\bH\u0002J\u0016\u0010s\u001a\b\u0012\u0004\u0012\u00020t0\u00072\u0006\u0010>\u001a\u00020?H\u0016J\u0018\u0010u\u001a\u00020=2\u0006\u0010v\u001a\u00020w2\u0006\u0010@\u001a\u00020xH\u0016J\u0018\u0010y\u001a\u00020=2\u0006\u0010V\u001a\u00020z2\u0006\u0010P\u001a\u00020YH\u0016J\u0018\u0010{\u001a\u00020=2\u0006\u0010|\u001a\u00020}2\u0006\u0010@\u001a\u00020~H\u0016JK\u0010\u007f\u001a\u0005\u0018\u0001H\u0080\u0001\"\n\b\u0000\u0010\u0081\u0001*\u00030\u0082\u0001\"\n\b\u0001\u0010\u0080\u0001*\u00030\u0082\u00012\u0016\u0010\u0083\u0001\u001a\u0011\u0012\u0005\u0012\u0003H\u0081\u0001\u0012\u0005\u0012\u0003H\u0080\u00010\u0084\u00012\b\u0010\u0085\u0001\u001a\u0003H\u0081\u0001H\u0002\u00a2\u0006\u0003\u0010\u0086\u0001JG\u0010\u0087\u0001\u001a\u00020=2\n\u0010\u0088\u0001\u001a\u0005\u0018\u00010\u0089\u00012\u0014\u0010\u008a\u0001\u001a\u000f\u0012\u0005\u0012\u00030\u008b\u0001\u0012\u0004\u0012\u00020=0l2\u001a\b\u0002\u0010\u008c\u0001\u001a\u0013\u0012\u0007\u0012\u0005\u0018\u00010\u008d\u0001\u0012\u0004\u0012\u00020\r\u0018\u00010lH\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0016\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\u0016\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102R\u000e\u00103\u001a\u000204X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00105\u001a\u0002068TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b7\u00108R\u0014\u0010:\u001a\u00020\r8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b:\u0010;\u00a8\u0006\u008f\u0001"}, d2={"Lorg/jetbrains/kotlin/fir/backend/jvm/FirJvmSerializerExtension;", "Lorg/jetbrains/kotlin/fir/serialization/FirSerializerExtension;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "bindings", "Lorg/jetbrains/kotlin/codegen/serialization/JvmSerializationBindings;", "localDelegatedProperties", "", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "globalBindings", "useTypeTable", "", "moduleName", "", "classBuilderMode", "Lorg/jetbrains/kotlin/codegen/ClassBuilderMode;", "isParamAssertionsDisabled", "unifiedNullChecks", "metadataVersion", "Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;", "jvmDefaultMode", "Lorg/jetbrains/kotlin/config/JvmDefaultMode;", "stringTable", "Lorg/jetbrains/kotlin/fir/serialization/FirElementAwareStringTable;", "constValueProvider", "Lorg/jetbrains/kotlin/fir/serialization/constant/ConstValueProvider;", "additionalMetadataProvider", "Lorg/jetbrains/kotlin/fir/serialization/FirAdditionalMetadataProvider;", "<init>", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/codegen/serialization/JvmSerializationBindings;Ljava/util/List;Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;Lorg/jetbrains/kotlin/codegen/serialization/JvmSerializationBindings;ZLjava/lang/String;Lorg/jetbrains/kotlin/codegen/ClassBuilderMode;ZZLorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;Lorg/jetbrains/kotlin/config/JvmDefaultMode;Lorg/jetbrains/kotlin/fir/serialization/FirElementAwareStringTable;Lorg/jetbrains/kotlin/fir/serialization/constant/ConstValueProvider;Lorg/jetbrains/kotlin/fir/serialization/FirAdditionalMetadataProvider;)V", "state", "Lorg/jetbrains/kotlin/codegen/state/GenerationState;", "approximator", "Lorg/jetbrains/kotlin/types/AbstractTypeApproximator;", "components", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrComponents;", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/codegen/serialization/JvmSerializationBindings;Lorg/jetbrains/kotlin/codegen/state/GenerationState;Ljava/util/List;Lorg/jetbrains/kotlin/types/AbstractTypeApproximator;Lorg/jetbrains/kotlin/fir/backend/Fir2IrComponents;Lorg/jetbrains/kotlin/fir/serialization/FirElementAwareStringTable;)V", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "getScopeSession", "()Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "getMetadataVersion", "()Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;", "getStringTable", "()Lorg/jetbrains/kotlin/fir/serialization/FirElementAwareStringTable;", "getConstValueProvider", "()Lorg/jetbrains/kotlin/fir/serialization/constant/ConstValueProvider;", "getAdditionalMetadataProvider", "()Lorg/jetbrains/kotlin/fir/serialization/FirAdditionalMetadataProvider;", "signatureSerializer", "Lorg/jetbrains/kotlin/fir/backend/jvm/FirJvmSignatureSerializer;", "localClassIdOracle", "Lorg/jetbrains/kotlin/fir/serialization/LocalClassIdOracle;", "getLocalClassIdOracle", "()Lorg/jetbrains/kotlin/fir/serialization/LocalClassIdOracle;", "shouldUseTypeTable", "isOptionalAnnotationClassSerialization", "()Z", "serializeClass", "", "klass", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "proto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Class$Builder;", "versionRequirementTable", "Lorg/jetbrains/kotlin/metadata/serialization/MutableVersionRequirementTable;", "childSerializer", "Lorg/jetbrains/kotlin/fir/serialization/FirElementSerializer;", "isInCompatibilityMode", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "serializeScript", "script", "Lorg/jetbrains/kotlin/fir/declarations/FirScript;", "serializeSnippet", "snippet", "Lorg/jetbrains/kotlin/fir/declarations/FirReplSnippet;", "processScriptOrSnippet", "writeVersionRequirementForJvmDefaultIfNeeded", "builder", "serializePackage", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Package$Builder;", "serializeFlexibleType", "type", "Lorg/jetbrains/kotlin/fir/types/ConeFlexibleType;", "lowerProto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Type$Builder;", "upperProto", "serializeTypeAnnotations", "annotations", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;", "serializeTypeParameter", "typeParameter", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeParameter;", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$TypeParameter$Builder;", "serializeConstructor", "constructor", "Lorg/jetbrains/kotlin/fir/declarations/FirConstructor;", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Constructor$Builder;", "serializeFunction", "function", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Function$Builder;", "writeInlineParameterNullCheckRequirement", "add", "Lkotlin/Function1;", "", "needsInlineParameterNullCheckRequirement", "serializeProperty", "property", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Property$Builder;", "isJvmFieldPropertyInInterfaceCompanion", "getClassSupertypes", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "serializeValueParameter", "parameter", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$ValueParameter$Builder;", "serializeErrorType", "Lorg/jetbrains/kotlin/fir/types/ConeErrorType;", "serializeEnumEntry", "enumEntry", "Lorg/jetbrains/kotlin/fir/declarations/FirEnumEntry;", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$EnumEntry$Builder;", "getBinding", "V", "K", "", "slice", "Lorg/jetbrains/kotlin/codegen/serialization/JvmSerializationBindings$SerializationMappingSlice;", "key", "(Lorg/jetbrains/kotlin/codegen/serialization/JvmSerializationBindings$SerializationMappingSlice;Ljava/lang/Object;)Ljava/lang/Object;", "serializeAnnotations", "declaration", "Lorg/jetbrains/kotlin/fir/FirAnnotationContainer;", "addAnnotation", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Annotation;", "matchUseSiteTarget", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationUseSiteTarget;", "Companion", "jvm-backend"})
@SourceDebugExtension(value={"SMAP\nFirJvmSerializerExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJvmSerializerExtension.kt\norg/jetbrains/kotlin/fir/backend/jvm/FirJvmSerializerExtension\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n*L\n1#1,447:1\n1#2:448\n42#3:449\n55#3:450\n23#3:451\n1761#4,3:452\n827#4:462\n855#4,2:463\n65#5,7:455\n*S KotlinDebug\n*F\n+ 1 FirJvmSerializerExtension.kt\norg/jetbrains/kotlin/fir/backend/jvm/FirJvmSerializerExtension\n*L\n280#1:449\n280#1:450\n281#1:451\n282#1:452,3\n356#1:462\n356#1:463,2\n339#1:455,7\n*E\n"})
public class FirJvmSerializerExtension
extends FirSerializerExtension {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FirSession session;
    @NotNull
    private final JvmSerializationBindings bindings;
    @NotNull
    private final List<FirProperty> localDelegatedProperties;
    @NotNull
    private final ScopeSession scopeSession;
    @NotNull
    private final JvmSerializationBindings globalBindings;
    private final boolean useTypeTable;
    @NotNull
    private final String moduleName;
    @NotNull
    private final ClassBuilderMode classBuilderMode;
    private final boolean isParamAssertionsDisabled;
    private final boolean unifiedNullChecks;
    @NotNull
    private final BinaryVersion metadataVersion;
    @NotNull
    private final JvmDefaultMode jvmDefaultMode;
    @NotNull
    private final FirElementAwareStringTable stringTable;
    @Nullable
    private final ConstValueProvider constValueProvider;
    @Nullable
    private final FirAdditionalMetadataProvider additionalMetadataProvider;
    @NotNull
    private final FirJvmSignatureSerializer signatureSerializer;
    @NotNull
    private static final JvmSerializationBindings.SerializationMappingSlice<FirFunction, Method> METHOD_FOR_FIR_FUNCTION;
    @NotNull
    private static final JvmSerializationBindings.SerializationMappingSlice<FirProperty, Pair<Type, String>> FIELD_FOR_PROPERTY;
    @NotNull
    private static final JvmSerializationBindings.SerializationMappingSlice<FirVariable, Method> SYNTHETIC_METHOD_FOR_FIR_VARIABLE;
    @NotNull
    private static final JvmSerializationBindings.SerializationMappingSlice<FirVariable, Method> DELEGATE_METHOD_FOR_FIR_VARIABLE;

    public FirJvmSerializerExtension(@NotNull FirSession session, @NotNull JvmSerializationBindings bindings, @NotNull List<? extends FirProperty> localDelegatedProperties, @NotNull ScopeSession scopeSession, @NotNull JvmSerializationBindings globalBindings, boolean useTypeTable, @NotNull String moduleName2, @NotNull ClassBuilderMode classBuilderMode, boolean isParamAssertionsDisabled, boolean unifiedNullChecks, @NotNull BinaryVersion metadataVersion, @NotNull JvmDefaultMode jvmDefaultMode, @NotNull FirElementAwareStringTable stringTable2, @Nullable ConstValueProvider constValueProvider, @Nullable FirAdditionalMetadataProvider additionalMetadataProvider) {
        Intrinsics.checkNotNullParameter(session, "session");
        Intrinsics.checkNotNullParameter(bindings, "bindings");
        Intrinsics.checkNotNullParameter(localDelegatedProperties, "localDelegatedProperties");
        Intrinsics.checkNotNullParameter(scopeSession, "scopeSession");
        Intrinsics.checkNotNullParameter(globalBindings, "globalBindings");
        Intrinsics.checkNotNullParameter(moduleName2, "moduleName");
        Intrinsics.checkNotNullParameter(classBuilderMode, "classBuilderMode");
        Intrinsics.checkNotNullParameter(metadataVersion, "metadataVersion");
        Intrinsics.checkNotNullParameter((Object)jvmDefaultMode, "jvmDefaultMode");
        Intrinsics.checkNotNullParameter(stringTable2, "stringTable");
        this.session = session;
        this.bindings = bindings;
        this.localDelegatedProperties = localDelegatedProperties;
        this.scopeSession = scopeSession;
        this.globalBindings = globalBindings;
        this.useTypeTable = useTypeTable;
        this.moduleName = moduleName2;
        this.classBuilderMode = classBuilderMode;
        this.isParamAssertionsDisabled = isParamAssertionsDisabled;
        this.unifiedNullChecks = unifiedNullChecks;
        this.metadataVersion = metadataVersion;
        this.jvmDefaultMode = jvmDefaultMode;
        this.stringTable = stringTable2;
        this.constValueProvider = constValueProvider;
        this.additionalMetadataProvider = additionalMetadataProvider;
        this.signatureSerializer = new FirJvmSignatureSerializer(this.stringTable);
    }

    @Override
    @NotNull
    public FirSession getSession() {
        return this.session;
    }

    @Override
    @NotNull
    public ScopeSession getScopeSession() {
        return this.scopeSession;
    }

    @Override
    @NotNull
    public BinaryVersion getMetadataVersion() {
        return this.metadataVersion;
    }

    @Override
    @NotNull
    public final FirElementAwareStringTable getStringTable() {
        return this.stringTable;
    }

    @Override
    @Nullable
    public ConstValueProvider getConstValueProvider() {
        return this.constValueProvider;
    }

    @Override
    @Nullable
    public FirAdditionalMetadataProvider getAdditionalMetadataProvider() {
        return this.additionalMetadataProvider;
    }

    public FirJvmSerializerExtension(@NotNull FirSession session, @NotNull JvmSerializationBindings bindings, @NotNull GenerationState state, @NotNull List<? extends FirProperty> localDelegatedProperties, @NotNull AbstractTypeApproximator approximator, @NotNull Fir2IrComponents components, @NotNull FirElementAwareStringTable stringTable2) {
        Intrinsics.checkNotNullParameter(session, "session");
        Intrinsics.checkNotNullParameter(bindings, "bindings");
        Intrinsics.checkNotNullParameter(state, "state");
        Intrinsics.checkNotNullParameter(localDelegatedProperties, "localDelegatedProperties");
        Intrinsics.checkNotNullParameter(approximator, "approximator");
        Intrinsics.checkNotNullParameter(components, "components");
        Intrinsics.checkNotNullParameter(stringTable2, "stringTable");
        this(session, bindings, localDelegatedProperties, components.getScopeSession(), state.getGlobalSerializationBindings(), state.getConfig().getUseTypeTableInSerializer(), state.getModuleName(), state.getClassBuilderMode(), state.getConfig().isParamAssertionsDisabled(), state.getConfig().getUnifiedNullChecks(), state.getConfig().getMetadataVersion(), state.getConfig().getJvmDefaultMode(), stringTable2, new ConstValueProviderImpl(components), components.getAnnotationsFromPluginRegistrar().createAdditionalMetadataProvider());
    }

    @Override
    @NotNull
    protected LocalClassIdOracle getLocalClassIdOracle() {
        return new LocalClassIdOracle(){

            public ClassId getLocalClassId(KClassValue.Value.LocalClass klass) {
                Intrinsics.checkNotNullParameter(klass, "klass");
                Object object = klass.getIrClass();
                IrClass irClass = object instanceof IrClass ? (IrClass)object : null;
                if (irClass == null) {
                    return null;
                }
                IrClass irClass2 = irClass;
                Type type = JvmIrAttributesKt.getLocalClassType(irClass2);
                if (type == null) {
                    return null;
                }
                Type type2 = type;
                String string = type2.getInternalName();
                Intrinsics.checkNotNullExpressionValue(string, "getInternalName(...)");
                FqName fqName = new FqName(StringsKt.replace$default(string, '/', '.', false, 4, null));
                return new ClassId(fqName.parent(), FqName.Companion.topLevel(fqName.shortName()), true);
            }
        };
    }

    @Override
    public boolean shouldUseTypeTable() {
        return this.useTypeTable;
    }

    protected boolean isOptionalAnnotationClassSerialization() {
        return false;
    }

    @Override
    public void serializeClass(@NotNull FirClass klass, @NotNull ProtoBuf.Class.Builder proto, @NotNull MutableVersionRequirementTable versionRequirementTable, @NotNull FirElementSerializer childSerializer) {
        Intrinsics.checkNotNullParameter(klass, "klass");
        Intrinsics.checkNotNullParameter(proto, "proto");
        Intrinsics.checkNotNullParameter(versionRequirementTable, "versionRequirementTable");
        Intrinsics.checkNotNullParameter(childSerializer, "childSerializer");
        if (!Intrinsics.areEqual(this.moduleName, "main")) {
            proto.setExtension(JvmProtoBuf.classModuleName, this.stringTable.getStringIndex(this.moduleName));
        }
        for (FirProperty localVariable : this.localDelegatedProperties) {
            ProtoBuf.PropertyOrBuilder propertyOrBuilder = childSerializer.propertyProto(localVariable);
            if (propertyOrBuilder == null || (propertyOrBuilder = propertyOrBuilder.build()) == null) continue;
            proto.addExtension(JvmProtoBuf.classLocalVariable, propertyOrBuilder);
        }
        this.writeVersionRequirementForJvmDefaultIfNeeded(klass, proto, versionRequirementTable);
        if (this.jvmDefaultMode.isEnabled() && klass instanceof FirRegularClass && ((FirRegularClass)klass).getClassKind() == ClassKind.INTERFACE) {
            proto.setExtension(JvmProtoBuf.jvmClassFlags, JvmFlags.INSTANCE.getClassFlags(true, this.isInCompatibilityMode((FirRegularClass)klass)));
        }
        FirJvmSerializerExtension.serializeAnnotations$default(this, klass, new Function1<ProtoBuf.Annotation, Unit>((Object)proto){

            public final void invoke(ProtoBuf.Annotation p0) {
                ((ProtoBuf.Class.Builder)this.receiver).addAnnotation(p0);
            }
        }, null, 4, null);
    }

    private final boolean isInCompatibilityMode(FirRegularClass klass) {
        return this.jvmDefaultMode == JvmDefaultMode.ENABLE && !FirAnnotationUtilsKt.hasAnnotation(klass, JvmStandardClassIds.INSTANCE.getJVM_DEFAULT_WITHOUT_COMPATIBILITY_CLASS_ID(), this.getSession()) || this.jvmDefaultMode == JvmDefaultMode.NO_COMPATIBILITY && FirAnnotationUtilsKt.hasAnnotation(klass, JvmStandardClassIds.INSTANCE.getJVM_DEFAULT_WITH_COMPATIBILITY_CLASS_ID(), this.getSession());
    }

    @Override
    public void serializeScript(@NotNull FirScript script, @NotNull ProtoBuf.Class.Builder proto, @NotNull MutableVersionRequirementTable versionRequirementTable, @NotNull FirElementSerializer childSerializer) {
        Intrinsics.checkNotNullParameter(script, "script");
        Intrinsics.checkNotNullParameter(proto, "proto");
        Intrinsics.checkNotNullParameter(versionRequirementTable, "versionRequirementTable");
        Intrinsics.checkNotNullParameter(childSerializer, "childSerializer");
        this.processScriptOrSnippet(proto, childSerializer);
    }

    @Override
    public void serializeSnippet(@NotNull FirReplSnippet snippet, @NotNull ProtoBuf.Class.Builder proto, @NotNull MutableVersionRequirementTable versionRequirementTable, @NotNull FirElementSerializer childSerializer) {
        Intrinsics.checkNotNullParameter(snippet, "snippet");
        Intrinsics.checkNotNullParameter(proto, "proto");
        Intrinsics.checkNotNullParameter(versionRequirementTable, "versionRequirementTable");
        Intrinsics.checkNotNullParameter(childSerializer, "childSerializer");
        this.processScriptOrSnippet(proto, childSerializer);
    }

    private final void processScriptOrSnippet(ProtoBuf.Class.Builder proto, FirElementSerializer childSerializer) {
        if (!Intrinsics.areEqual(this.moduleName, "main")) {
            proto.setExtension(JvmProtoBuf.classModuleName, this.stringTable.getStringIndex(this.moduleName));
        }
        for (FirProperty localVariable : this.localDelegatedProperties) {
            ProtoBuf.PropertyOrBuilder propertyOrBuilder = childSerializer.propertyProto(localVariable);
            if (propertyOrBuilder == null || (propertyOrBuilder = propertyOrBuilder.build()) == null) continue;
            proto.addExtension(JvmProtoBuf.classLocalVariable, propertyOrBuilder);
        }
    }

    private final void writeVersionRequirementForJvmDefaultIfNeeded(FirClass klass, ProtoBuf.Class.Builder builder, MutableVersionRequirementTable versionRequirementTable) {
        if (klass instanceof FirRegularClass && ((FirRegularClass)klass).getClassKind() == ClassKind.INTERFACE && this.jvmDefaultMode == JvmDefaultMode.NO_COMPATIBILITY) {
            builder.addVersionRequirement(DescriptorSerializer.Companion.writeVersionRequirement(1, 4, 0, ProtoBuf.VersionRequirement.VersionKind.COMPILER_VERSION, versionRequirementTable));
        }
    }

    @Override
    public void serializePackage(@NotNull FqName packageFqName, @NotNull ProtoBuf.Package.Builder proto, @Nullable MutableVersionRequirementTable versionRequirementTable, @NotNull FirElementSerializer childSerializer) {
        Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
        Intrinsics.checkNotNullParameter(proto, "proto");
        Intrinsics.checkNotNullParameter(childSerializer, "childSerializer");
        if (!Intrinsics.areEqual(this.moduleName, "main")) {
            proto.setExtension(JvmProtoBuf.packageModuleName, this.stringTable.getStringIndex(this.moduleName));
        }
        for (FirProperty localVariable : this.localDelegatedProperties) {
            ProtoBuf.PropertyOrBuilder propertyOrBuilder = childSerializer.propertyProto(localVariable);
            if (propertyOrBuilder == null || (propertyOrBuilder = propertyOrBuilder.build()) == null) continue;
            proto.addExtension(JvmProtoBuf.packageLocalVariable, propertyOrBuilder);
        }
    }

    @Override
    public void serializeFlexibleType(@NotNull ConeFlexibleType type, @NotNull ProtoBuf.Type.Builder lowerProto, @NotNull ProtoBuf.Type.Builder upperProto) {
        Intrinsics.checkNotNullParameter(type, "type");
        Intrinsics.checkNotNullParameter(lowerProto, "lowerProto");
        Intrinsics.checkNotNullParameter(upperProto, "upperProto");
        lowerProto.setFlexibleTypeCapabilitiesId(this.stringTable.getStringIndex("kotlin.jvm.PlatformType"));
        if (type instanceof ConeRawType) {
            lowerProto.setExtension(JvmProtoBuf.isRaw, true);
            upperProto.setExtension(JvmProtoBuf.isRaw, true);
        }
    }

    @Override
    public void serializeTypeAnnotations(@NotNull List<? extends FirAnnotation> annotations2, @NotNull ProtoBuf.Type.Builder proto) {
        Intrinsics.checkNotNullParameter(annotations2, "annotations");
        Intrinsics.checkNotNullParameter(proto, "proto");
        for (FirAnnotation firAnnotation : annotations2) {
            proto.addExtension(JvmProtoBuf.typeAnnotation, this.getAnnotationSerializer().serializeAnnotation(firAnnotation));
        }
    }

    @Override
    public void serializeTypeParameter(@NotNull FirTypeParameter typeParameter, @NotNull ProtoBuf.TypeParameter.Builder proto) {
        Intrinsics.checkNotNullParameter(typeParameter, "typeParameter");
        Intrinsics.checkNotNullParameter(proto, "proto");
        for (FirAnnotation annotation : FirAnnotationUtilsKt.nonSourceAnnotations(typeParameter, this.getSession())) {
            proto.addExtension(JvmProtoBuf.typeParameterAnnotation, this.getAnnotationSerializer().serializeAnnotation(annotation));
        }
    }

    @Override
    public void serializeConstructor(@NotNull FirConstructor constructor, @NotNull ProtoBuf.Constructor.Builder proto, @NotNull FirElementSerializer childSerializer) {
        JvmProtoBuf.JvmMethodSignature signature;
        Intrinsics.checkNotNullParameter(constructor, "constructor");
        Intrinsics.checkNotNullParameter(proto, "proto");
        Intrinsics.checkNotNullParameter(childSerializer, "childSerializer");
        Method method = this.getBinding(METHOD_FOR_FIR_FUNCTION, constructor);
        if (method != null && (signature = this.signatureSerializer.methodSignature(constructor, null, method)) != null) {
            proto.setExtension(JvmProtoBuf.constructorSignature, signature);
        }
        FirJvmSerializerExtension.serializeAnnotations$default(this, constructor, new Function1<ProtoBuf.Annotation, Unit>((Object)proto){

            public final void invoke(ProtoBuf.Annotation p0) {
                ((ProtoBuf.Constructor.Builder)this.receiver).addAnnotation(p0);
            }
        }, null, 4, null);
    }

    @Override
    public void serializeFunction(@NotNull FirFunction function2, @NotNull ProtoBuf.Function.Builder proto, @Nullable MutableVersionRequirementTable versionRequirementTable, @NotNull FirElementSerializer childSerializer) {
        block4: {
            Intrinsics.checkNotNullParameter(function2, "function");
            Intrinsics.checkNotNullParameter(proto, "proto");
            Intrinsics.checkNotNullParameter(childSerializer, "childSerializer");
            Method method = this.getBinding(METHOD_FOR_FIR_FUNCTION, function2);
            if (method != null) {
                FirSimpleFunction firSimpleFunction = function2 instanceof FirSimpleFunction ? (FirSimpleFunction)function2 : null;
                JvmProtoBuf.JvmMethodSignature signature = this.signatureSerializer.methodSignature(function2, firSimpleFunction != null ? firSimpleFunction.getName() : null, method);
                if (signature != null) {
                    proto.setExtension(JvmProtoBuf.methodSignature, signature);
                }
            }
            if (this.needsInlineParameterNullCheckRequirement(function2)) {
                MutableVersionRequirementTable mutableVersionRequirementTable = versionRequirementTable;
                if (mutableVersionRequirementTable != null) {
                    this.writeInlineParameterNullCheckRequirement(mutableVersionRequirementTable, (Function1<? super Integer, Unit>)new Function1<Integer, Unit>((Object)proto){

                        public final void invoke(int p0) {
                            ((ProtoBuf.Function.Builder)this.receiver).addVersionRequirement(p0);
                        }
                    });
                }
            }
            FirJvmSerializerExtension.serializeAnnotations$default(this, function2, new Function1<ProtoBuf.Annotation, Unit>((Object)proto){

                public final void invoke(ProtoBuf.Annotation p0) {
                    ((ProtoBuf.Function.Builder)this.receiver).addAnnotation(p0);
                }
            }, null, 4, null);
            FirReceiverParameter firReceiverParameter = function2.getReceiverParameter();
            if (firReceiverParameter == null) break block4;
            FirReceiverParameter it = firReceiverParameter;
            boolean bl = false;
            FirJvmSerializerExtension.serializeAnnotations$default(this, it, new Function1<ProtoBuf.Annotation, Unit>((Object)proto){

                public final void invoke(ProtoBuf.Annotation p0) {
                    ((ProtoBuf.Function.Builder)this.receiver).addExtensionReceiverAnnotation(p0);
                }
            }, null, 4, null);
        }
    }

    private final void writeInlineParameterNullCheckRequirement(MutableVersionRequirementTable $this$writeInlineParameterNullCheckRequirement, Function1<? super Integer, Unit> add) {
        if (this.unifiedNullChecks) {
            add.invoke((Integer)DescriptorSerializer.Companion.writeVersionRequirement(1, 3, 50, ProtoBuf.VersionRequirement.VersionKind.COMPILER_VERSION, $this$writeInlineParameterNullCheckRequirement));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean needsInlineParameterNullCheckRequirement(FirFunction $this$needsInlineParameterNullCheckRequirement) {
        boolean bl;
        if (!($this$needsInlineParameterNullCheckRequirement instanceof FirSimpleFunction)) return false;
        FirMemberDeclaration $this$isInline$iv = $this$needsInlineParameterNullCheckRequirement;
        boolean $i$f$isInline = false;
        if (!$this$isInline$iv.getStatus().isInline()) return false;
        FirMemberDeclaration $this$isSuspend$iv = $this$needsInlineParameterNullCheckRequirement;
        boolean $i$f$isSuspend = false;
        if ($this$isSuspend$iv.getStatus().isSuspend()) return false;
        if (this.isParamAssertionsDisabled) return false;
        FirMemberDeclaration $this$visibility$iv = $this$needsInlineParameterNullCheckRequirement;
        boolean $i$f$getVisibility = false;
        if (Visibilities.INSTANCE.isPrivate($this$visibility$iv.getStatus().getVisibility())) return false;
        Iterable $this$any$iv = ((FirSimpleFunction)$this$needsInlineParameterNullCheckRequirement).getValueParameters();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            bl = false;
        } else {
            for (Object element$iv : $this$any$iv) {
                FirValueParameter it = (FirValueParameter)element$iv;
                boolean bl2 = false;
                if (!FunctionalTypeUtilsKt.isSomeFunctionType(FirTypeUtilsKt.getConeType(it.getReturnTypeRef()), this.getSession())) continue;
                return true;
            }
            bl = false;
        }
        if (bl) return true;
        FirReceiverParameter firReceiverParameter = ((FirSimpleFunction)$this$needsInlineParameterNullCheckRequirement).getReceiverParameter();
        Object object = firReceiverParameter;
        if (firReceiverParameter == null) return false;
        FirTypeRef firTypeRef = ((FirReceiverParameter)object).getTypeRef();
        object = firTypeRef;
        if (firTypeRef == null) return false;
        ConeKotlinType coneKotlinType = FirTypeUtilsKt.getConeType((FirTypeRef)object);
        object = coneKotlinType;
        if (coneKotlinType == null) return false;
        if (!FunctionalTypeUtilsKt.isSomeFunctionType((ConeKotlinType)object, this.getSession())) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void serializeProperty(@NotNull FirProperty property2, @NotNull ProtoBuf.Property.Builder proto, @Nullable MutableVersionRequirementTable versionRequirementTable, @NotNull FirElementSerializer childSerializer) {
        block13: {
            FirPropertyAccessor setter2;
            FirPropertyAccessor getter2;
            block12: {
                block11: {
                    boolean bl;
                    boolean bl2;
                    Intrinsics.checkNotNullParameter(property2, "property");
                    Intrinsics.checkNotNullParameter(proto, "proto");
                    Intrinsics.checkNotNullParameter(childSerializer, "childSerializer");
                    getter2 = property2.getGetter();
                    setter2 = property2.getSetter();
                    Method getterMethod = getter2 == null ? null : this.getBinding(METHOD_FOR_FIR_FUNCTION, getter2);
                    Method setterMethod = setter2 == null ? null : this.getBinding(METHOD_FOR_FIR_FUNCTION, setter2);
                    Pair<Type, String> field = this.getBinding(FIELD_FOR_PROPERTY, property2);
                    Method syntheticMethod = this.getBinding(SYNTHETIC_METHOD_FOR_FIR_VARIABLE, property2);
                    Method delegateMethod = this.getBinding(DELEGATE_METHOD_FOR_FIR_VARIABLE, property2);
                    boolean bl3 = bl2 = property2.getDelegate() != null || delegateMethod == null;
                    if (_Assertions.ENABLED && !bl2) {
                        boolean bl4 = false;
                        String string = "non-delegated property " + UtilsKt.render(property2) + " has delegate method";
                        throw new AssertionError((Object)string);
                    }
                    FirJvmSignatureSerializer firJvmSignatureSerializer = this.signatureSerializer;
                    Name name2 = property2.getName();
                    Pair<Type, String> pair = field;
                    String string = pair != null ? pair.getSecond() : null;
                    Pair<Type, String> pair2 = field;
                    String string2 = pair2 != null && (pair2 = pair2.getFirst()) != null ? ((Type)((Object)pair2)).getDescriptor() : null;
                    JvmProtoBuf.JvmMethodSignature jvmMethodSignature = syntheticMethod != null ? this.signatureSerializer.methodSignature(null, null, syntheticMethod) : null;
                    JvmProtoBuf.JvmMethodSignature jvmMethodSignature2 = delegateMethod != null ? this.signatureSerializer.methodSignature(null, null, delegateMethod) : null;
                    JvmProtoBuf.JvmMethodSignature jvmMethodSignature3 = getterMethod != null ? this.signatureSerializer.methodSignature(null, null, getterMethod) : null;
                    JvmProtoBuf.JvmMethodSignature jvmMethodSignature4 = setterMethod != null ? this.signatureSerializer.methodSignature(null, null, setterMethod) : null;
                    Pair<Type, String> pair3 = field;
                    if (pair3 != null && (pair3 = pair3.getFirst()) != null && (pair3 = ((Type)((Object)pair3)).getDescriptor()) != null) {
                        void it;
                        Pair<Type, String> pair4 = pair3;
                        JvmProtoBuf.JvmMethodSignature jvmMethodSignature5 = jvmMethodSignature4;
                        JvmProtoBuf.JvmMethodSignature jvmMethodSignature6 = jvmMethodSignature3;
                        JvmProtoBuf.JvmMethodSignature jvmMethodSignature7 = jvmMethodSignature2;
                        JvmProtoBuf.JvmMethodSignature jvmMethodSignature8 = jvmMethodSignature;
                        String string3 = string2;
                        String string4 = string;
                        Name name3 = name2;
                        FirJvmSignatureSerializer firJvmSignatureSerializer2 = firJvmSignatureSerializer;
                        boolean bl5 = false;
                        boolean bl6 = this.signatureSerializer.requiresPropertySignature(property2, (String)it);
                        firJvmSignatureSerializer = firJvmSignatureSerializer2;
                        name2 = name3;
                        string = string4;
                        string2 = string3;
                        jvmMethodSignature = jvmMethodSignature8;
                        jvmMethodSignature2 = jvmMethodSignature7;
                        jvmMethodSignature3 = jvmMethodSignature6;
                        jvmMethodSignature4 = jvmMethodSignature5;
                        bl = bl6;
                    } else {
                        bl = false;
                    }
                    JvmProtoBuf.JvmPropertySignature signature = firJvmSignatureSerializer.propertySignature(name2, string, string2, jvmMethodSignature, jvmMethodSignature2, jvmMethodSignature3, jvmMethodSignature4, bl);
                    if (signature != null) {
                        proto.setExtension(JvmProtoBuf.propertySignature, signature);
                    }
                    if (this.isJvmFieldPropertyInInterfaceCompanion(property2) && versionRequirementTable != null) {
                        proto.setExtension(JvmProtoBuf.flags, JvmFlags.INSTANCE.getPropertyFlags(true));
                    }
                    FirPropertyAccessor firPropertyAccessor = getter2;
                    if (firPropertyAccessor != null ? this.needsInlineParameterNullCheckRequirement(firPropertyAccessor) : false) break block11;
                    FirPropertyAccessor firPropertyAccessor2 = setter2;
                    boolean bl7 = firPropertyAccessor2 != null ? this.needsInlineParameterNullCheckRequirement(firPropertyAccessor2) : false;
                    if (!bl7) break block12;
                }
                MutableVersionRequirementTable mutableVersionRequirementTable = versionRequirementTable;
                if (mutableVersionRequirementTable != null) {
                    this.writeInlineParameterNullCheckRequirement(mutableVersionRequirementTable, (Function1<? super Integer, Unit>)new Function1<Integer, Unit>((Object)proto){

                        public final void invoke(int p0) {
                            ((ProtoBuf.Property.Builder)this.receiver).addVersionRequirement(p0);
                        }
                    });
                }
            }
            FirJvmSerializerExtension.serializeAnnotations$default(this, getter2, new Function1<ProtoBuf.Annotation, Unit>((Object)proto){

                public final void invoke(ProtoBuf.Annotation p0) {
                    ((ProtoBuf.Property.Builder)this.receiver).addGetterAnnotation(p0);
                }
            }, null, 4, null);
            FirJvmSerializerExtension.serializeAnnotations$default(this, setter2, new Function1<ProtoBuf.Annotation, Unit>((Object)proto){

                public final void invoke(ProtoBuf.Annotation p0) {
                    ((ProtoBuf.Property.Builder)this.receiver).addSetterAnnotation(p0);
                }
            }, null, 4, null);
            FirJvmSerializerExtension.serializeAnnotations$default(this, property2, new Function1<ProtoBuf.Annotation, Unit>((Object)proto){

                public final void invoke(ProtoBuf.Annotation p0) {
                    ((ProtoBuf.Property.Builder)this.receiver).addAnnotation(p0);
                }
            }, null, 4, null);
            FirReceiverParameter firReceiverParameter = property2.getReceiverParameter();
            if (firReceiverParameter != null) {
                FirReceiverParameter it = firReceiverParameter;
                boolean bl = false;
                FirJvmSerializerExtension.serializeAnnotations$default(this, it, new Function1<ProtoBuf.Annotation, Unit>((Object)proto){

                    public final void invoke(ProtoBuf.Annotation p0) {
                        ((ProtoBuf.Property.Builder)this.receiver).addExtensionReceiverAnnotation(p0);
                    }
                }, null, 4, null);
            }
            FirBackingField firBackingField = property2.getBackingField();
            if (firBackingField == null) break block13;
            FirBackingField field = firBackingField;
            boolean bl = false;
            this.serializeAnnotations(field, (Function1<? super ProtoBuf.Annotation, Unit>)new Function1<ProtoBuf.Annotation, Unit>((Object)proto){

                public final void invoke(ProtoBuf.Annotation p0) {
                    ((ProtoBuf.Property.Builder)this.receiver).addBackingFieldAnnotation(p0);
                }
            }, FirJvmSerializerExtension::serializeProperty$lambda$12$lambda$10);
            this.serializeAnnotations(field, (Function1<? super ProtoBuf.Annotation, Unit>)new Function1<ProtoBuf.Annotation, Unit>((Object)proto){

                public final void invoke(ProtoBuf.Annotation p0) {
                    ((ProtoBuf.Property.Builder)this.receiver).addDelegateFieldAnnotation(p0);
                }
            }, FirJvmSerializerExtension::serializeProperty$lambda$12$lambda$11);
        }
    }

    private final boolean isJvmFieldPropertyInInterfaceCompanion(FirProperty $this$isJvmFieldPropertyInInterfaceCompanion) {
        FirRegularClass firRegularClass;
        FirRegularClassSymbol containerSymbol;
        block7: {
            block6: {
                if (!JavaUtilsKt.hasJvmFieldAnnotation($this$isJvmFieldPropertyInInterfaceCompanion, this.getSession())) {
                    return false;
                }
                Object object = $this$isJvmFieldPropertyInInterfaceCompanion.getDispatchReceiverType();
                FirRegularClassSymbol firRegularClassSymbol = object != null && (object = ConeTypeUtilsKt.getClassLikeLookupTagIfAny((ConeKotlinType)object)) != null ? ToSymbolUtilsKt.toRegularClassSymbol((ConeClassLikeLookupTag)object, this.getSession()) : (containerSymbol = null);
                if (containerSymbol == null) break block6;
                FirClassLikeSymbol $this$isCompanion$iv = containerSymbol;
                boolean $i$f$isCompanion = false;
                if (!$this$isCompanion$iv.getRawStatus().isCompanion()) break block6;
                FirClassLikeSymbol $this$isLocal$iv = containerSymbol;
                boolean $i$f$isLocal = false;
                if (!$this$isLocal$iv.getClassId().isLocal()) break block7;
            }
            return false;
        }
        ClassId classId = containerSymbol.getClassId().getOuterClassId();
        if (classId != null) {
            ClassId it = classId;
            boolean bl = false;
            FirRegularClassSymbol firRegularClassSymbol = FirSymbolProviderKt.getRegularClassSymbolByClassId(this.getSession(), it);
            firRegularClass = firRegularClassSymbol != null ? (FirRegularClass)firRegularClassSymbol.getFir() : null;
        } else {
            firRegularClass = null;
        }
        FirRegularClass grandParent = firRegularClass;
        return grandParent != null && (grandParent.getClassKind() == ClassKind.INTERFACE || grandParent.getClassKind() == ClassKind.ANNOTATION_CLASS);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<FirTypeRef> getClassSupertypes(@NotNull FirClass klass) {
        Intrinsics.checkNotNullParameter(klass, "klass");
        if (Intrinsics.areEqual(this.classBuilderMode, ClassBuilderMode.KAPT3)) {
            List<FirImplicitBuiltinTypeRef> list;
            void $this$filterNotTo$iv$iv;
            Iterable $this$filterNot$iv = super.getClassSupertypes(klass);
            boolean $i$f$filterNot = false;
            Iterable iterable = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                FirTypeRef it = (FirTypeRef)element$iv$iv;
                boolean bl = false;
                if (FirTypeUtilsKt.getConeType(it) instanceof ConeErrorType) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List<FirImplicitBuiltinTypeRef> list2 = (List)destination$iv$iv;
            if (list2.isEmpty()) {
                boolean bl = false;
                list = CollectionsKt.listOf(this.getSession().getBuiltinTypes().getAnyType());
            } else {
                list = list2;
            }
            return list;
        }
        return super.getClassSupertypes(klass);
    }

    @Override
    public void serializeValueParameter(@NotNull FirValueParameter parameter, @NotNull ProtoBuf.ValueParameter.Builder proto) {
        Intrinsics.checkNotNullParameter(parameter, "parameter");
        Intrinsics.checkNotNullParameter(proto, "proto");
        FirJvmSerializerExtension.serializeAnnotations$default(this, parameter, new Function1<ProtoBuf.Annotation, Unit>((Object)proto){

            public final void invoke(ProtoBuf.Annotation p0) {
                ((ProtoBuf.ValueParameter.Builder)this.receiver).addAnnotation(p0);
            }
        }, null, 4, null);
    }

    @Override
    public void serializeErrorType(@NotNull ConeErrorType type, @NotNull ProtoBuf.Type.Builder builder) {
        Intrinsics.checkNotNullParameter(type, "type");
        Intrinsics.checkNotNullParameter(builder, "builder");
        if (this.classBuilderMode == ClassBuilderMode.KAPT3) {
            builder.setClassName(this.stringTable.getStringIndex("error/NonExistentClass"));
            return;
        }
        super.serializeErrorType(type, builder);
    }

    @Override
    public void serializeEnumEntry(@NotNull FirEnumEntry enumEntry, @NotNull ProtoBuf.EnumEntry.Builder proto) {
        Intrinsics.checkNotNullParameter(enumEntry, "enumEntry");
        Intrinsics.checkNotNullParameter(proto, "proto");
        FirJvmSerializerExtension.serializeAnnotations$default(this, enumEntry, new Function1<ProtoBuf.Annotation, Unit>((Object)proto){

            public final void invoke(ProtoBuf.Annotation p0) {
                ((ProtoBuf.EnumEntry.Builder)this.receiver).addAnnotation(p0);
            }
        }, null, 4, null);
    }

    private final <K, V> V getBinding(JvmSerializationBindings.SerializationMappingSlice<K, V> slice, K key) {
        V v2 = this.bindings.get(slice, key);
        if (v2 == null) {
            v2 = this.globalBindings.get(slice, key);
        }
        return v2;
    }

    private final void serializeAnnotations(FirAnnotationContainer declaration, Function1<? super ProtoBuf.Annotation, Unit> addAnnotation, Function1<? super AnnotationUseSiteTarget, Boolean> matchUseSiteTarget) {
        if (FirLanguageSettingsComponentKt.getLanguageVersionSettings(this.getSession()).supportsFeature(LanguageFeature.AnnotationsInMetadata) || CollectionsKt.contains((Iterable)this.localDelegatedProperties, declaration) || this.isOptionalAnnotationClassSerialization()) {
            FirAnnotationContainer firAnnotationContainer = declaration;
            List<FirAnnotation> list = firAnnotationContainer != null ? SerializationUtilKt.allRequiredAnnotations(firAnnotationContainer, this.getSession(), this.getAdditionalMetadataProvider()) : null;
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            for (FirAnnotation annotation : list) {
                if (matchUseSiteTarget != null && !matchUseSiteTarget.invoke(annotation.getUseSiteTarget()).booleanValue()) continue;
                addAnnotation.invoke(this.getAnnotationSerializer().serializeAnnotation(annotation));
            }
        }
    }

    static /* synthetic */ void serializeAnnotations$default(FirJvmSerializerExtension firJvmSerializerExtension, FirAnnotationContainer firAnnotationContainer, Function1 function1, Function1 function12, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: serializeAnnotations");
        }
        if ((n2 & 4) != 0) {
            function12 = null;
        }
        firJvmSerializerExtension.serializeAnnotations(firAnnotationContainer, function1, function12);
    }

    private static final boolean serializeProperty$lambda$12$lambda$10(AnnotationUseSiteTarget it) {
        return it != AnnotationUseSiteTarget.PROPERTY_DELEGATE_FIELD;
    }

    private static final boolean serializeProperty$lambda$12$lambda$11(AnnotationUseSiteTarget it) {
        return it == AnnotationUseSiteTarget.PROPERTY_DELEGATE_FIELD;
    }

    static {
        JvmSerializationBindings.SerializationMappingSlice serializationMappingSlice = JvmSerializationBindings.SerializationMappingSlice.create();
        Intrinsics.checkNotNullExpressionValue(serializationMappingSlice, "create(...)");
        METHOD_FOR_FIR_FUNCTION = serializationMappingSlice;
        JvmSerializationBindings.SerializationMappingSlice serializationMappingSlice2 = JvmSerializationBindings.SerializationMappingSlice.create();
        Intrinsics.checkNotNullExpressionValue(serializationMappingSlice2, "create(...)");
        FIELD_FOR_PROPERTY = serializationMappingSlice2;
        JvmSerializationBindings.SerializationMappingSlice serializationMappingSlice3 = JvmSerializationBindings.SerializationMappingSlice.create();
        Intrinsics.checkNotNullExpressionValue(serializationMappingSlice3, "create(...)");
        SYNTHETIC_METHOD_FOR_FIR_VARIABLE = serializationMappingSlice3;
        JvmSerializationBindings.SerializationMappingSlice serializationMappingSlice4 = JvmSerializationBindings.SerializationMappingSlice.create();
        Intrinsics.checkNotNullExpressionValue(serializationMappingSlice4, "create(...)");
        DELEGATE_METHOD_FOR_FIR_VARIABLE = serializationMappingSlice4;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR)\u0010\n\u001a\u001a\u0012\u0004\u0012\u00020\u000b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\tR\u001d\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\tR\u001d\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\t\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/fir/backend/jvm/FirJvmSerializerExtension$Companion;", "", "<init>", "()V", "METHOD_FOR_FIR_FUNCTION", "Lorg/jetbrains/kotlin/codegen/serialization/JvmSerializationBindings$SerializationMappingSlice;", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "Lorg/jetbrains/org/objectweb/asm/commons/Method;", "getMETHOD_FOR_FIR_FUNCTION", "()Lorg/jetbrains/kotlin/codegen/serialization/JvmSerializationBindings$SerializationMappingSlice;", "FIELD_FOR_PROPERTY", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "Lkotlin/Pair;", "Lorg/jetbrains/org/objectweb/asm/Type;", "", "getFIELD_FOR_PROPERTY", "SYNTHETIC_METHOD_FOR_FIR_VARIABLE", "Lorg/jetbrains/kotlin/fir/declarations/FirVariable;", "getSYNTHETIC_METHOD_FOR_FIR_VARIABLE", "DELEGATE_METHOD_FOR_FIR_VARIABLE", "getDELEGATE_METHOD_FOR_FIR_VARIABLE", "jvm-backend"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JvmSerializationBindings.SerializationMappingSlice<FirFunction, Method> getMETHOD_FOR_FIR_FUNCTION() {
            return METHOD_FOR_FIR_FUNCTION;
        }

        @NotNull
        public final JvmSerializationBindings.SerializationMappingSlice<FirProperty, Pair<Type, String>> getFIELD_FOR_PROPERTY() {
            return FIELD_FOR_PROPERTY;
        }

        @NotNull
        public final JvmSerializationBindings.SerializationMappingSlice<FirVariable, Method> getSYNTHETIC_METHOD_FOR_FIR_VARIABLE() {
            return SYNTHETIC_METHOD_FOR_FIR_VARIABLE;
        }

        @NotNull
        public final JvmSerializationBindings.SerializationMappingSlice<FirVariable, Method> getDELEGATE_METHOD_FOR_FIR_VARIABLE() {
            return DELEGATE_METHOD_FOR_FIR_VARIABLE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

