/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental;

import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.containers.FileCollectionFactory;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.File;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.BuildRootDescriptor;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.DirtyFilesHolder;
import org.jetbrains.jps.builders.FileProcessor;
import org.jetbrains.jps.builders.ModuleBasedTarget;
import org.jetbrains.jps.builders.java.JavaBuilderUtil;
import org.jetbrains.jps.builders.logging.ProjectBuilderLogger;
import org.jetbrains.jps.builders.storage.SourceToOutputMapping;
import org.jetbrains.jps.cmdline.ProjectDescriptor;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.FSOperations;
import org.jetbrains.jps.incremental.IncProjectBuilder;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.ProjectBuildException;
import org.jetbrains.jps.incremental.Utils;
import org.jetbrains.jps.incremental.fs.BuildFSState;
import org.jetbrains.jps.incremental.fs.CompilationRound;
import org.jetbrains.jps.incremental.messages.DoneSomethingNotification;
import org.jetbrains.jps.incremental.messages.FileDeletedEvent;
import org.jetbrains.jps.incremental.storage.BuildDataManager;
import org.jetbrains.jps.incremental.storage.BuildTargetConfiguration;
import org.jetbrains.jps.incremental.storage.StampsStorage;

public final class BuildOperations {
    private BuildOperations() {
    }

    public static void ensureFSStateInitialized(@NotNull CompileContext context, @NotNull BuildTarget<?> target, boolean readOnly) throws IOException {
        if (context == null) {
            BuildOperations.$$$reportNull$$$0(0);
        }
        if (target == null) {
            BuildOperations.$$$reportNull$$$0(1);
        }
        ProjectDescriptor projectDescriptor = context.getProjectDescriptor();
        BuildTargetConfiguration configuration = projectDescriptor.dataManager.getTargetStateManager().getTargetConfiguration(target);
        if (JavaBuilderUtil.isForcedRecompilationAllJavaModules(context)) {
            StampsStorage<?> stampStorage = projectDescriptor.dataManager.getFileStampStorage(target);
            FSOperations.markDirtyFiles(context, target, CompilationRound.CURRENT, stampStorage, true, null, null);
            projectDescriptor.fsState.markInitialScanPerformed(target);
            if (!readOnly) {
                configuration.save(context);
            }
        } else {
            boolean isTargetDirty = false;
            if (context.getScope().isBuildForced(target) || (isTargetDirty = configuration.isTargetDirty(context.getProjectDescriptor())) || !projectDescriptor.getBuildRootIndex().getTargetRoots(target, context).isEmpty() && configuration.outputRootWasDeleted(context)) {
                if (isTargetDirty) {
                    configuration.logDiagnostics(context);
                }
                BuildOperations.initTargetFSState(context, target, true);
                if (!readOnly) {
                    if (!context.getScope().isBuildForced(target)) {
                        IncProjectBuilder.clearOutputFiles(context, target);
                    }
                    projectDescriptor.dataManager.cleanTargetStorages(target);
                    configuration.save(context);
                }
            } else if (!projectDescriptor.fsState.isInitialScanPerformed(target)) {
                BuildOperations.initTargetFSState(context, target, false);
            }
        }
    }

    @ApiStatus.Internal
    public static void initTargetFSState(CompileContext context, BuildTarget<?> target, boolean forceMarkDirty) throws IOException {
        ProjectDescriptor projectDescriptor = context.getProjectDescriptor();
        StampsStorage<?> stampStorage = projectDescriptor.dataManager.getFileStampStorage(target);
        Set currentFiles = FileCollectionFactory.createCanonicalPathSet();
        FSOperations.markDirtyFiles(context, target, CompilationRound.CURRENT, stampStorage, forceMarkDirty, currentFiles, null);
        BuildFSState fsState = projectDescriptor.fsState;
        SourceToOutputMapping sourceToOutputMap = projectDescriptor.dataManager.getSourceToOutputMap(target);
        Iterator<Path> it = sourceToOutputMap.getSourceFileIterator();
        while (it.hasNext()) {
            Path file = it.next();
            if (currentFiles.contains(file)) continue;
            fsState.registerDeleted(context, target, file, stampStorage);
        }
        projectDescriptor.fsState.markInitialScanPerformed(target);
    }

    public static void markTargetsUpToDate(@NotNull CompileContext context, @NotNull Collection<? extends BuildTarget<?>> targets) throws IOException {
        if (context == null) {
            BuildOperations.$$$reportNull$$$0(2);
        }
        if (targets == null) {
            BuildOperations.$$$reportNull$$$0(3);
        }
        ProjectDescriptor projectDescriptor = context.getProjectDescriptor();
        BuildFSState fsState = projectDescriptor.fsState;
        BuildDataManager dataManager = projectDescriptor.dataManager;
        for (BuildTarget<?> target : targets) {
            dataManager.getTargetStateManager().storeNonExistentOutputRoots(target, context);
        }
        if (Utils.errorsDetected(context) || context.getCancelStatus().isCanceled()) {
            return;
        }
        boolean marked = BuildOperations.dropRemovedPaths(context, targets);
        for (BuildTarget<?> target : targets) {
            if (target instanceof ModuleBuildTarget) {
                context.clearNonIncrementalMark((ModuleBuildTarget)target);
            }
            StampsStorage<?> stampStorage = dataManager.getFileStampStorage(target);
            long targetBuildStartStamp = context.getCompilationStartStamp(target);
            for (BuildRootDescriptor buildRootDescriptor : projectDescriptor.getBuildRootIndex().getTargetRoots(target, context)) {
                marked |= fsState.markAllUpToDate(context, buildRootDescriptor, stampStorage, targetBuildStartStamp);
            }
        }
        if (marked) {
            context.processMessage(DoneSomethingNotification.INSTANCE);
        }
    }

    private static boolean dropRemovedPaths(@NotNull CompileContext context, @NotNull Collection<? extends BuildTarget<?>> targets) throws IOException {
        Map map;
        if (context == null) {
            BuildOperations.$$$reportNull$$$0(4);
        }
        if (targets == null) {
            BuildOperations.$$$reportNull$$$0(5);
        }
        if ((map = (Map)Utils.REMOVED_SOURCES_KEY.get((UserDataHolder)context)) == null) {
            return false;
        }
        boolean dropped = false;
        for (BuildTarget<?> target : targets) {
            Collection paths = (Collection)map.remove(target);
            if (paths == null) continue;
            SourceToOutputMapping storage = context.getProjectDescriptor().dataManager.getSourceToOutputMap(target);
            for (Path file : paths) {
                storage.remove(file);
            }
            dropped = true;
        }
        return dropped;
    }

    public static <R extends BuildRootDescriptor, T extends BuildTarget<R>> Map<T, Map<Path, List<Path>>> cleanOutputsCorrespondingToChangedFiles(@NotNull CompileContext context, @NotNull DirtyFilesHolder<R, T> dirtyFilesHolder) throws ProjectBuildException {
        if (context == null) {
            BuildOperations.$$$reportNull$$$0(6);
        }
        if (dirtyFilesHolder == null) {
            BuildOperations.$$$reportNull$$$0(7);
        }
        final BuildDataManager dataManager = context.getProjectDescriptor().dataManager;
        try {
            final HashMap sourcesToCleanedOutputByTargets = new HashMap();
            final Set dirsToDelete = FileCollectionFactory.createCanonicalPathSet();
            final ArrayList<String> allDeletedOutputPaths = new ArrayList<String>();
            dirtyFilesHolder.processDirtyFiles(new FileProcessor<R, T>(){
                private final Map<T, SourceToOutputMapping> mappingsCache = new HashMap();
                private final Object2IntMap<T> idsCache = new Object2IntOpenHashMap();

                @Override
                public boolean apply(@NotNull T target, @NotNull File ioFile, @NotNull R sourceRoot) throws IOException {
                    int targetId;
                    SourceToOutputMapping srcToOut;
                    if (target == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (ioFile == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (sourceRoot == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    if ((srcToOut = this.mappingsCache.get(target)) == null) {
                        srcToOut = dataManager.getSourceToOutputMap((BuildTarget<?>)target);
                        this.mappingsCache.put(target, srcToOut);
                    }
                    if (!this.idsCache.containsKey(target)) {
                        targetId = dataManager.getTargetStateManager().getBuildTargetId((BuildTarget<?>)target);
                        this.idsCache.put(target, targetId);
                    } else {
                        targetId = this.idsCache.getInt(target);
                    }
                    Path file = ioFile.toPath();
                    Collection<Path> outputs2 = srcToOut.getOutputs(file);
                    ArrayList<Path> failedToDeleteOutputs = new ArrayList<Path>();
                    if (outputs2 == null) {
                        return true;
                    }
                    boolean shouldPruneOutputDirs = target instanceof ModuleBasedTarget;
                    ArrayList<String> deletedForThisSource = new ArrayList<String>(outputs2.size());
                    for (Path outputFile : outputs2) {
                        boolean deletedSuccessfully = BuildOperations.deleteRecursivelyAndCollectDeleted(outputFile, deletedForThisSource, shouldPruneOutputDirs ? dirsToDelete : null);
                        if (deletedSuccessfully || !Files.exists(outputFile, new LinkOption[0])) continue;
                        failedToDeleteOutputs.add(outputFile);
                    }
                    allDeletedOutputPaths.addAll(deletedForThisSource);
                    dataManager.getOutputToTargetMapping().removeMappings(deletedForThisSource, targetId, srcToOut);
                    Map cleaned = sourcesToCleanedOutputByTargets.computeIfAbsent(target, k -> new HashMap());
                    cleaned.put(file, failedToDeleteOutputs);
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "target";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "ioFile";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[0] = "sourceRoot";
                            break;
                        }
                    }
                    objectArray[1] = "org/jetbrains/jps/incremental/BuildOperations$1";
                    objectArray[2] = "apply";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            if (!allDeletedOutputPaths.isEmpty()) {
                ProjectBuilderLogger logger;
                if (JavaBuilderUtil.isCompileJavaIncrementally(context) && (logger = context.getLoggingManager().getProjectBuilderLogger()).isEnabled()) {
                    logger.logDeletedFiles(allDeletedOutputPaths);
                }
                context.processMessage(new FileDeletedEvent(allDeletedOutputPaths));
            }
            FSOperations.pruneEmptyDirs(context, dirsToDelete);
            return sourcesToCleanedOutputByTargets;
        }
        catch (Exception e) {
            throw new ProjectBuildException(e);
        }
    }

    @Deprecated
    public static boolean deleteRecursively(@NotNull String path, @NotNull Collection<String> deletedPaths, @Nullable Set<File> parentDirs) {
        if (path == null) {
            BuildOperations.$$$reportNull$$$0(8);
        }
        if (deletedPaths == null) {
            BuildOperations.$$$reportNull$$$0(9);
        }
        Set<Path> nioParentDirs = parentDirs == null ? null : parentDirs.stream().map(file -> file.toPath()).collect(Collectors.toSet());
        return BuildOperations.deleteRecursivelyAndCollectDeleted(Path.of(path, new String[0]), deletedPaths, nioParentDirs);
    }

    public static boolean deleteRecursivelyAndCollectDeleted(@NotNull Path file, @NotNull Collection<String> deletedPaths, @Nullable Set<Path> parentDirs) {
        Path parent;
        boolean deleted;
        if (file == null) {
            BuildOperations.$$$reportNull$$$0(10);
        }
        if (deletedPaths == null) {
            BuildOperations.$$$reportNull$$$0(11);
        }
        if ((deleted = BuildOperations.deleteRecursively(file, deletedPaths)) && parentDirs != null && (parent = file.getParent()) != null) {
            parentDirs.add(parent);
        }
        return deleted;
    }

    private static boolean deleteRecursively(@NotNull Path file, final @NotNull Collection<String> deletedPaths) {
        if (file == null) {
            BuildOperations.$$$reportNull$$$0(12);
        }
        if (deletedPaths == null) {
            BuildOperations.$$$reportNull$$$0(13);
        }
        try {
            Files.walkFileTree(file, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path f, BasicFileAttributes attrs) throws IOException {
                    block2: {
                        try {
                            Files.delete(f);
                        }
                        catch (AccessDeniedException e) {
                            if (f.toFile().delete()) break block2;
                            throw e;
                        }
                    }
                    deletedPaths.add(FileUtilRt.toSystemIndependentName((String)f.toString()));
                    return FileVisitResult.CONTINUE;
                }

                @Override
                @NotNull
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    block3: {
                        try {
                            Files.delete(dir);
                        }
                        catch (AccessDeniedException e) {
                            if (dir.toFile().delete()) break block3;
                            throw e;
                        }
                    }
                    FileVisitResult fileVisitResult = FileVisitResult.CONTINUE;
                    if (fileVisitResult == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return fileVisitResult;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/incremental/BuildOperations$2", "postVisitDirectory"));
                }
            });
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targets";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirtyFilesHolder";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deletedPaths";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/jps/incremental/BuildOperations";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "ensureFSStateInitialized";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "markTargetsUpToDate";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "dropRemovedPaths";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "cleanOutputsCorrespondingToChangedFiles";
                break;
            }
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "deleteRecursively";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "deleteRecursivelyAndCollectDeleted";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

