/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ExtendedResolutionApiKt;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.intentions.SelfTargetingRangeIntention;
import org.jetbrains.kotlin.idea.codeinsight.utils.ChooseStringExpression;
import org.jetbrains.kotlin.idea.intentions.AddForLoopIndicesIntentionKt;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u001a\u0010\t\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u00022\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J \u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/AddForLoopIndicesIntention;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/intentions/SelfTargetingRangeIntention;", "Lorg/jetbrains/kotlin/psi/KtForExpression;", "Lcom/intellij/codeInsight/intention/LowPriorityAction;", "<init>", "()V", "applicabilityRange", "Lcom/intellij/openapi/util/TextRange;", "element", "applyTo", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "runTemplate", "forExpression", "indexVariable", "Lorg/jetbrains/kotlin/psi/KtDestructuringDeclarationEntry;", "createWithIndexExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "originalExpression", "reformat", "", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nAddForLoopIndicesIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AddForLoopIndicesIntention.kt\norg/jetbrains/kotlin/idea/intentions/AddForLoopIndicesIntention\n+ 2 KotlinPsiModificationUtils.kt\norg/jetbrains/kotlin/idea/base/psi/KotlinPsiModificationUtils\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,103:1\n29#2,7:104\n1#3:111\n*S KotlinDebug\n*F\n+ 1 AddForLoopIndicesIntention.kt\norg/jetbrains/kotlin/idea/intentions/AddForLoopIndicesIntention\n*L\n59#1:104,7\n*E\n"})
public final class AddForLoopIndicesIntention
extends SelfTargetingRangeIntention<KtForExpression>
implements LowPriorityAction {
    public AddForLoopIndicesIntention() {
        super(KtForExpression.class, KotlinBundle.lazyMessage((String)"add.indices.to.for.loop", (Object[])new Object[0]), null, 4, null);
    }

    @Override
    @Nullable
    public TextRange applicabilityRange(@NotNull KtForExpression element) {
        ResolvedCall resolvedCall;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (element.getLoopParameter() == null) {
            return null;
        }
        KtParameter ktParameter = element.getLoopParameter();
        if ((ktParameter != null ? ktParameter.getDestructuringDeclaration() : null) != null) {
            return null;
        }
        KtExpression ktExpression = element.getLoopRange();
        if (ktExpression == null) {
            return null;
        }
        KtExpression loopRange = ktExpression;
        BindingContext bindingContext = ResolutionUtils.analyze((KtElement)element, BodyResolveMode.PARTIAL_WITH_CFA);
        ResolvedCall resolvedCall2 = CallUtilKt.getResolvedCall((KtElement)((KtElement)loopRange), (BindingContext)bindingContext);
        if (CollectionsKt.contains((Iterable)AddForLoopIndicesIntentionKt.access$getWITH_INDEX_FQ_NAMES(), (resolvedCall = resolvedCall2) != null && (resolvedCall = resolvedCall.getResultingDescriptor()) != null && (resolvedCall = DescriptorUtilsKt.getFqNameUnsafe((DeclarationDescriptor)((DeclarationDescriptor)resolvedCall))) != null ? resolvedCall.asString() : null)) {
            return null;
        }
        KtExpression potentialExpression = this.createWithIndexExpression(loopRange, false);
        BindingContext newBindingContext = ExtendedResolutionApiKt.analyzeAsReplacement$default(potentialExpression, loopRange, bindingContext, null, null, null, 28, null);
        ResolvedCall resolvedCall3 = CallUtilKt.getResolvedCall((KtElement)((KtElement)potentialExpression), (BindingContext)newBindingContext);
        if (resolvedCall3 == null) {
            return null;
        }
        ResolvedCall newResolvedCall = resolvedCall3;
        Set set = AddForLoopIndicesIntentionKt.access$getWITH_INDEX_FQ_NAMES();
        CallableDescriptor callableDescriptor = newResolvedCall.getResultingDescriptor();
        Intrinsics.checkNotNullExpressionValue((Object)callableDescriptor, (String)"getResultingDescriptor(...)");
        if (!set.contains(DescriptorUtilsKt.getFqNameUnsafe((DeclarationDescriptor)((DeclarationDescriptor)callableDescriptor)).asString())) {
            return null;
        }
        KtExpression ktExpression2 = element.getBody();
        return new TextRange(PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)element)), ktExpression2 != null ? PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)ktExpression2)) : PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)element)));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void applyTo(@NotNull KtForExpression element, @Nullable Editor editor) {
        PsiElement psiElement;
        void $this$replaced$iv;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (editor == null) {
            throw new IllegalArgumentException("This intention requires an editor");
        }
        KtExpression ktExpression = element.getLoopRange();
        Intrinsics.checkNotNull((Object)ktExpression);
        KtExpression loopRange = ktExpression;
        KtParameter ktParameter = element.getLoopParameter();
        Intrinsics.checkNotNull((Object)ktParameter);
        KtParameter loopParameter2 = ktParameter;
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KtPsiFactory psiFactory = new KtPsiFactory(project, false, 2, null);
        loopRange.replace((PsiElement)this.createWithIndexExpression(loopRange, true));
        Object[] objectArray = new Object[1];
        Intrinsics.checkNotNullExpressionValue((Object)loopParameter2.getText(), (String)"getText(...)");
        KtExpression ktExpression2 = CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)psiFactory, (String)"for((index, $0) in x){}", (Object[])objectArray, (boolean)false, (int)4, null);
        Intrinsics.checkNotNull((Object)ktExpression2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtForExpression");
        KtDestructuringDeclaration ktDestructuringDeclaration = ((KtForExpression)ktExpression2).getDestructuringDeclaration();
        Intrinsics.checkNotNull((Object)ktDestructuringDeclaration);
        KtDestructuringDeclaration multiParameter = ktDestructuringDeclaration;
        ktExpression2 = (PsiElement)loopParameter2;
        PsiElement newElement$iv = (PsiElement)multiParameter;
        boolean $i$f$replaced = false;
        if (Intrinsics.areEqual((Object)$this$replaced$iv, (Object)newElement$iv)) {
            psiElement = newElement$iv;
        } else {
            PsiElement result$iv = $this$replaced$iv.replace(newElement$iv);
            if (result$iv instanceof KtDestructuringDeclaration) {
                psiElement = result$iv;
            } else {
                Intrinsics.checkNotNull((Object)result$iv, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                KtExpression ktExpression3 = ((KtParenthesizedExpression)result$iv).getExpression();
                if (ktExpression3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtDestructuringDeclaration");
                }
                psiElement = (PsiElement)((KtDestructuringDeclaration)ktExpression3);
            }
        }
        multiParameter = (KtDestructuringDeclaration)psiElement;
        KtDestructuringDeclarationEntry indexVariable = (KtDestructuringDeclarationEntry)multiParameter.getEntries().get(0);
        CaretModel caretModel = editor.getCaretModel();
        Intrinsics.checkNotNull((Object)indexVariable);
        caretModel.moveToOffset(PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)indexVariable)));
        this.runTemplate(editor, element, indexVariable);
    }

    private final void runTemplate(Editor editor, KtForExpression forExpression, KtDestructuringDeclarationEntry indexVariable) {
        PsiDocumentManager.getInstance((Project)forExpression.getProject()).doPostponedOperationsAndUnblockDocument(editor.getDocument());
        TemplateBuilderImpl templateBuilder = new TemplateBuilderImpl((PsiElement)forExpression);
        Object[] objectArray = new String[]{"index", "i"};
        templateBuilder.replaceElement((PsiElement)indexVariable, (Expression)new ChooseStringExpression((Collection)CollectionsKt.listOf((Object[])objectArray), null, null, 6, null));
        KtExpression body2 = forExpression.getBody();
        if (body2 instanceof KtBlockExpression) {
            List list2 = ((KtBlockExpression)body2).getStatements();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getStatements(...)");
            KtExpression statement = (KtExpression)CollectionsKt.firstOrNull((List)list2);
            if (statement != null) {
                templateBuilder.setEndVariableBefore((PsiElement)statement);
            } else {
                templateBuilder.setEndVariableAfter(((KtBlockExpression)body2).getLBrace());
            }
        } else if (body2 == null) {
            PsiElement it = forExpression.getRightParenthesis();
            boolean bl = false;
            templateBuilder.setEndVariableAfter(it);
        } else {
            templateBuilder.setEndVariableBefore((PsiElement)body2);
        }
        templateBuilder.run(editor, true);
    }

    private final KtExpression createWithIndexExpression(KtExpression originalExpression2, boolean reformat) {
        Project project = originalExpression2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Object[] objectArray = new Object[]{originalExpression2};
        return CreateByPatternKt.createExpressionByPattern((KtPsiFactory)new KtPsiFactory(project, false, 2, null), (String)"$0.withIndex()", (Object[])objectArray, (boolean)reformat);
    }
}

