/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ExtendedResolutionApiKt;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.intentions.conventionNameCalls.ConventionUtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/UnusedEqualsInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/inspections/AbstractKotlinInspection;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "kotlin.idea"})
public final class UnusedEqualsInspection
extends AbstractKotlinInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder2, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder2, (String)"holder");
        return (PsiElementVisitor)new KtVisitorVoid(holder2){
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.$holder = $holder;
            }

            private final void reportIfNotUsedAsExpression(KtExpression expression) {
                BindingContext context = ExtendedResolutionApiKt.safeAnalyzeNonSourceRootCode$default((KtElement)expression, null, 1, null);
                if (!Intrinsics.areEqual((Object)context, (Object)BindingContext.EMPTY) && !BindingContextUtilsKt.isUsedAsExpression((KtElement)((KtElement)expression), (BindingContext)context)) {
                    this.$holder.registerProblem((PsiElement)expression, KotlinBundle.message((String)"unused.equals.expression", (Object[])new Object[0]), new LocalQuickFix[0]);
                }
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void visitBinaryExpression(KtBinaryExpression expression) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                super.visitBinaryExpression(expression);
                if (!Intrinsics.areEqual((Object)expression.getOperationToken(), (Object)KtTokens.EQEQ)) return;
                PsiElement parent2 = expression.getParent();
                if (parent2.getParent() instanceof KtIfExpression) {
                    bl = true;
                } else {
                    if (!(parent2 instanceof KtBlockExpression)) return;
                    if (((KtBlockExpression)parent2).getParent() instanceof KtCodeFragment) {
                        List list2 = ((KtBlockExpression)parent2).getStatements();
                        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getStatements(...)");
                        if (Intrinsics.areEqual((Object)CollectionsKt.lastOrNull((List)list2), (Object)expression)) return;
                    }
                    bl = true;
                }
                boolean shouldReport = bl;
                if (!shouldReport) return;
                this.reportIfNotUsedAsExpression((KtExpression)expression);
            }

            public void visitCallExpression(KtCallExpression expression) {
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                super.visitCallExpression(expression);
                KtExpression ktExpression = expression.getCalleeExpression();
                KtSimpleNameExpression ktSimpleNameExpression = ktExpression instanceof KtSimpleNameExpression ? (KtSimpleNameExpression)ktExpression : null;
                if (ktSimpleNameExpression == null) {
                    return;
                }
                KtSimpleNameExpression calleeExpression = ktSimpleNameExpression;
                if (!Intrinsics.areEqual((Object)calleeExpression.getReferencedNameAsName(), (Object)OperatorNameConventions.EQUALS)) {
                    return;
                }
                if (!ConventionUtilsKt.isAnyEquals((KtExpression)expression)) {
                    return;
                }
                this.reportIfNotUsedAsExpression(KtPsiUtilKt.getQualifiedExpressionForSelectorOrThis((KtExpression)((KtExpression)expression)));
            }
        };
    }
}

