/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.coroutine;

import com.intellij.debugger.engine.MethodInvokeUtils;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsImpl;
import com.intellij.debugger.impl.HelperClassNotAvailableException;
import com.intellij.debugger.impl.MethodNotFoundException;
import com.intellij.openapi.diagnostic.Logger;
import com.sun.jdi.Value;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.base.util.evaluate.DefaultExecutionContext;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u001aO\u0010\u0000\u001a\u0004\u0018\u00010\u00012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\t2\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u000b\"\u00020\u0007H\u0000\u00a2\u0006\u0002\u0010\f\u00a8\u0006\r"}, d2={"callMethodFromHelper", "Lcom/sun/jdi/Value;", "helperClass", "Ljava/lang/Class;", "context", "Lorg/jetbrains/kotlin/idea/debugger/base/util/evaluate/DefaultExecutionContext;", "methodName", "", "args", "", "additionalClassesToLoad", "", "(Ljava/lang/Class;Lorg/jetbrains/kotlin/idea/debugger/base/util/evaluate/DefaultExecutionContext;Ljava/lang/String;Ljava/util/List;[Ljava/lang/String;)Lcom/sun/jdi/Value;", "kotlin.jvm-debugger.coroutines"})
@SourceDebugExtension(value={"SMAP\nCoroutineStackFrameInterceptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoroutineStackFrameInterceptor.kt\norg/jetbrains/kotlin/idea/debugger/coroutine/CoroutineStackFrameInterceptorKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,259:1\n58#2:260\n36#2,2:261\n58#2:263\n36#2,2:264\n37#3:266\n36#3,3:267\n*S KotlinDebug\n*F\n+ 1 CoroutineStackFrameInterceptor.kt\norg/jetbrains/kotlin/idea/debugger/coroutine/CoroutineStackFrameInterceptorKt\n*L\n249#1:260\n249#1:261,2\n251#1:263\n251#1:264,2\n255#1:266\n255#1:267,3\n*E\n"})
public final class CoroutineStackFrameInterceptorKt {
    @Nullable
    public static final Value callMethodFromHelper(@NotNull Class<?> helperClass, @NotNull DefaultExecutionContext context, @NotNull String methodName, @NotNull List<? extends Value> args, String ... additionalClassesToLoad) {
        Intrinsics.checkNotNullParameter(helperClass, (String)"helperClass");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        Intrinsics.checkNotNullParameter(args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)additionalClassesToLoad, (String)"additionalClassesToLoad");
        try {
            return DebuggerUtilsImpl.invokeHelperMethod((EvaluationContextImpl)context.getEvaluationContext(), helperClass, (String)methodName, args, (boolean)true, (String[])Arrays.copyOf(additionalClassesToLoad, additionalClassesToLoad.length));
        }
        catch (HelperClassNotAvailableException e) {
            boolean $i$f$fileLogger = false;
            boolean $i$f$currentClassLogger = false;
            Class<?> clazz$iv$iv = MethodHandles.lookup().lookupClass();
            Logger logger = Logger.getInstance(clazz$iv$iv);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn((Throwable)e);
        }
        catch (MethodNotFoundException e) {
            boolean $i$f$fileLogger = false;
            boolean $i$f$currentClassLogger = false;
            Class<?> clazz$iv$iv = MethodHandles.lookup().lookupClass();
            Logger logger = Logger.getInstance(clazz$iv$iv);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn((Throwable)e);
        }
        catch (Exception e) {
            String helperExceptionStackTrace = MethodInvokeUtils.INSTANCE.getHelperExceptionStackTrace(context.getEvaluationContext(), e);
            Collection $this$toTypedArray$iv = CollectionsKt.listOfNotNull((Object)helperExceptionStackTrace);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            DebuggerUtilsImpl.logError((String)("Exception from helper: " + e.getMessage()), (Throwable)e, (String[])Arrays.copyOf(stringArray, stringArray.length));
        }
        return null;
    }
}

