/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.encrypt;

import java.awt.event.ActionEvent;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.EnabledAction;
import org.freeplane.features.encrypt.EncryptionController;
import org.freeplane.features.encrypt.SwingPasswordStrategy;
import org.freeplane.features.map.EncryptionModel;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;

@EnabledAction(checkOnNodeChange=true)
public class EnterPassword
extends AFreeplaneAction {
    private static final long serialVersionUID = 1L;
    private final EncryptionController encryptionController;

    public EnterPassword(EncryptionController encryptionController) {
        super("EnterPassword");
        this.encryptionController = encryptionController;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        NodeModel node = Controller.getCurrentModeController().getMapController().getSelectedNode();
        this.encryptionController.toggleLock(node, new SwingPasswordStrategy());
    }

    public boolean canBeEnabled() {
        ModeController modeController = Controller.getCurrentModeController();
        if (modeController == null) {
            return false;
        }
        boolean isEncryptedNode = false;
        boolean isOpened = false;
        MapController mapController = modeController.getMapController();
        NodeModel selectedNode = mapController.getSelectedNode();
        if (selectedNode != null) {
            if (modeController.canEdit()) {
                return true;
            }
            EncryptionModel enode = EncryptionModel.getModel(selectedNode);
            if (enode != null) {
                isEncryptedNode = true;
                isOpened = enode.isAccessible();
            }
        }
        return isEncryptedNode && !isOpened;
    }

    @Override
    public void setEnabled() {
        super.setEnabled(this.canBeEnabled());
    }
}

