/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize;

import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMethod;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.evaluation.value.Value;
import proguard.optimize.evaluation.StoringInvocationUnit;

public class ConstantParameterFilter
extends SimplifiedVisitor
implements MemberVisitor {
    private final MemberVisitor constantParameterVisitor;

    public ConstantParameterFilter(MemberVisitor constantParameterVisitor) {
        this.constantParameterVisitor = constantParameterVisitor;
    }

    @Override
    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        boolean isStatic = (programMethod.getAccessFlags() & 8) != 0;
        int parameterStart = isStatic ? 0 : 1;
        int parameterCount = ClassUtil.internalMethodParameterCount(programMethod.getDescriptor(programClass), isStatic);
        for (int index = parameterStart; index < parameterCount; ++index) {
            Value value = StoringInvocationUnit.getMethodParameterValue(programMethod, index);
            if (value == null || !value.isParticular()) continue;
            this.constantParameterVisitor.visitProgramMethod(programClass, programMethod);
        }
    }
}

