/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.rfb;

import com.tigervnc.rdr.InStream;
import com.tigervnc.rdr.MemInStream;
import com.tigervnc.rdr.OutStream;
import com.tigervnc.rdr.ZlibInStream;
import com.tigervnc.rfb.Decoder;
import com.tigervnc.rfb.Exception;
import com.tigervnc.rfb.ModifiablePixelBuffer;
import com.tigervnc.rfb.PixelFormat;
import com.tigervnc.rfb.Rect;
import com.tigervnc.rfb.ServerParams;
import java.nio.ByteBuffer;

public class ZRLEDecoder
extends Decoder {
    private ZlibInStream zis = new ZlibInStream();

    private static ByteBuffer readOpaque24A(InStream inStream) {
        inStream.check(3);
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.put(0, (byte)inStream.readU8());
        byteBuffer.put(1, (byte)inStream.readU8());
        byteBuffer.put(2, (byte)inStream.readU8());
        return byteBuffer;
    }

    private static ByteBuffer readOpaque24B(InStream inStream) {
        inStream.check(3);
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.put(1, (byte)inStream.readU8());
        byteBuffer.put(2, (byte)inStream.readU8());
        byteBuffer.put(3, (byte)inStream.readU8());
        return byteBuffer;
    }

    public ZRLEDecoder() {
        super(Decoder.DecoderFlags.DecoderOrdered);
    }

    @Override
    public void readRect(Rect rect, InStream inStream, ServerParams serverParams, OutStream outStream) {
        int n = inStream.readU32();
        outStream.writeU32(n);
        outStream.copyBytes(inStream, n);
    }

    @Override
    public void decodeRect(Rect rect, Object object, int n, ServerParams serverParams, ModifiablePixelBuffer modifiablePixelBuffer) {
        MemInStream memInStream = new MemInStream((byte[])object, 0, n);
        PixelFormat pixelFormat = serverParams.pf();
        switch (pixelFormat.bpp) {
            case 8: {
                this.zrleDecode8(rect, memInStream, this.zis, pixelFormat, modifiablePixelBuffer);
                break;
            }
            case 16: {
                this.zrleDecode16(rect, memInStream, this.zis, pixelFormat, modifiablePixelBuffer);
                break;
            }
            case 32: {
                if (pixelFormat.depth <= 24) {
                    boolean bl;
                    int n2 = pixelFormat.pixelFromRGB(-1, -1, -1, pixelFormat.getColorModel());
                    boolean bl2 = n2 < 0x1000000;
                    boolean bl3 = bl = (n2 & 0xFF) == 0;
                    if (bl2 && pixelFormat.isLittleEndian() || bl && pixelFormat.isBigEndian()) {
                        this.zrleDecode24A(rect, memInStream, this.zis, pixelFormat, modifiablePixelBuffer);
                        break;
                    }
                    if (bl2 && pixelFormat.isBigEndian() || bl && pixelFormat.isLittleEndian()) {
                        this.zrleDecode24B(rect, memInStream, this.zis, pixelFormat, modifiablePixelBuffer);
                        break;
                    }
                }
                this.zrleDecode32(rect, memInStream, this.zis, pixelFormat, modifiablePixelBuffer);
            }
        }
    }

    private static ByteBuffer READ_PIXEL(InStream inStream, PIXEL_T pIXEL_T) {
        switch (pIXEL_T) {
            case U8: {
                return ByteBuffer.allocate(1).put(0, (byte)inStream.readOpaque8());
            }
            case U16: {
                return ByteBuffer.allocate(2).putShort(0, (short)inStream.readOpaque16());
            }
            case U24A: {
                return ZRLEDecoder.readOpaque24A(inStream);
            }
            case U24B: {
                return ZRLEDecoder.readOpaque24B(inStream);
            }
        }
        return ByteBuffer.allocate(4).putInt(0, inStream.readOpaque32());
    }

    private void zrleDecode8(Rect rect, InStream inStream, ZlibInStream zlibInStream, PixelFormat pixelFormat, ModifiablePixelBuffer modifiablePixelBuffer) {
        this.ZRLE_DECODE(rect, inStream, zlibInStream, pixelFormat, modifiablePixelBuffer, PIXEL_T.U8);
    }

    private void zrleDecode16(Rect rect, InStream inStream, ZlibInStream zlibInStream, PixelFormat pixelFormat, ModifiablePixelBuffer modifiablePixelBuffer) {
        this.ZRLE_DECODE(rect, inStream, zlibInStream, pixelFormat, modifiablePixelBuffer, PIXEL_T.U16);
    }

    private void zrleDecode24A(Rect rect, InStream inStream, ZlibInStream zlibInStream, PixelFormat pixelFormat, ModifiablePixelBuffer modifiablePixelBuffer) {
        this.ZRLE_DECODE(rect, inStream, zlibInStream, pixelFormat, modifiablePixelBuffer, PIXEL_T.U24A);
    }

    private void zrleDecode24B(Rect rect, InStream inStream, ZlibInStream zlibInStream, PixelFormat pixelFormat, ModifiablePixelBuffer modifiablePixelBuffer) {
        this.ZRLE_DECODE(rect, inStream, zlibInStream, pixelFormat, modifiablePixelBuffer, PIXEL_T.U24B);
    }

    private void zrleDecode32(Rect rect, InStream inStream, ZlibInStream zlibInStream, PixelFormat pixelFormat, ModifiablePixelBuffer modifiablePixelBuffer) {
        this.ZRLE_DECODE(rect, inStream, zlibInStream, pixelFormat, modifiablePixelBuffer, PIXEL_T.U32);
    }

    private void ZRLE_DECODE(Rect rect, InStream inStream, ZlibInStream zlibInStream, PixelFormat pixelFormat, ModifiablePixelBuffer modifiablePixelBuffer, PIXEL_T pIXEL_T) {
        int n = inStream.readU32();
        zlibInStream.setUnderlying(inStream, n);
        Rect rect2 = new Rect();
        ByteBuffer byteBuffer = ByteBuffer.allocate(4096 * pixelFormat.bpp / 8);
        rect2.tl.y = rect.tl.y;
        while (rect2.tl.y < rect.br.y) {
            rect2.br.y = Math.min(rect.br.y, rect2.tl.y + 64);
            rect2.tl.x = rect.tl.x;
            while (rect2.tl.x < rect.br.x) {
                block22: {
                    block25: {
                        int n2;
                        int n3;
                        int n4;
                        ByteBuffer byteBuffer2;
                        int n5;
                        block23: {
                            int n6;
                            block24: {
                                boolean bl;
                                block21: {
                                    rect2.br.x = Math.min(rect.br.x, rect2.tl.x + 64);
                                    int n7 = zlibInStream.readU8();
                                    bl = (n7 & 0x80) != 0;
                                    n5 = n7 & 0x7F;
                                    byteBuffer2 = ByteBuffer.allocate(128 * pixelFormat.bpp / 8);
                                    for (n6 = 0; n6 < n5; ++n6) {
                                        byteBuffer2.put(ZRLEDecoder.READ_PIXEL(zlibInStream, pIXEL_T));
                                    }
                                    byteBuffer2.flip();
                                    if (n5 != 1) break block21;
                                    byte[] byArray = new byte[pixelFormat.bpp / 8];
                                    byteBuffer2.get(byArray);
                                    modifiablePixelBuffer.fillRect(pixelFormat, rect2, byArray);
                                    break block22;
                                }
                                if (bl) break block23;
                                if (n5 != 0) break block24;
                                switch (pIXEL_T) {
                                    case U24A: 
                                    case U24B: {
                                        ByteBuffer byteBuffer3 = byteBuffer.duplicate();
                                        for (n4 = 0; n4 < rect2.area(); ++n4) {
                                            byteBuffer3.put(ZRLEDecoder.READ_PIXEL(zlibInStream, pIXEL_T));
                                        }
                                        break block25;
                                    }
                                    default: {
                                        zlibInStream.readBytes(byteBuffer.duplicate(), rect2.area() * (pixelFormat.bpp / 8));
                                        break;
                                    }
                                }
                                break block25;
                            }
                            n6 = n5 > 16 ? 8 : (n5 > 4 ? 4 : (n5 > 2 ? 2 : 1));
                            ByteBuffer byteBuffer4 = byteBuffer.duplicate();
                            for (n3 = 0; n3 < rect2.height(); ++n3) {
                                n2 = byteBuffer4.position() + rect2.width() * pixelFormat.bpp / 8;
                                int n8 = 0;
                                int n9 = 0;
                                while (byteBuffer4.position() < n2) {
                                    if (n9 == 0) {
                                        n8 = zlibInStream.readU8();
                                        n9 = 8;
                                    }
                                    int n10 = n8 >> (n9 -= n6) & (1 << n6) - 1 & 0x7F;
                                    byteBuffer4.put(byteBuffer2.array(), n10 * pixelFormat.bpp / 8, pixelFormat.bpp / 8);
                                }
                            }
                            break block25;
                        }
                        if (n5 == 0) {
                            ByteBuffer byteBuffer5 = byteBuffer.duplicate();
                            n4 = byteBuffer5.position() + rect2.area() * pixelFormat.bpp / 8;
                            while (byteBuffer5.position() < n4) {
                                int n11;
                                ByteBuffer byteBuffer6 = ZRLEDecoder.READ_PIXEL(zlibInStream, pIXEL_T);
                                n2 = 1;
                                do {
                                    n11 = zlibInStream.readU8();
                                    n2 += n11;
                                } while (n11 == 255);
                                if (n4 - byteBuffer5.position() < n2 * pixelFormat.bpp / 8) {
                                    System.err.println("ZRLE decode error\n");
                                    throw new Exception("ZRLE decode error");
                                }
                                while (n2-- > 0) {
                                    byteBuffer5.put(byteBuffer6.array());
                                }
                            }
                        } else {
                            ByteBuffer byteBuffer7 = byteBuffer.duplicate();
                            n4 = byteBuffer7.position() + rect2.area() * pixelFormat.bpp / 8;
                            while (byteBuffer7.position() < n4) {
                                n3 = zlibInStream.readU8();
                                n2 = 1;
                                if ((n3 & 0x80) != 0) {
                                    int n12;
                                    do {
                                        n12 = zlibInStream.readU8();
                                        n2 += n12;
                                    } while (n12 == 255);
                                    if (n4 - byteBuffer7.position() < n2 * pixelFormat.bpp / 8) {
                                        System.err.println("ZRLE decode error\n");
                                        throw new Exception("ZRLE decode error");
                                    }
                                }
                                ByteBuffer byteBuffer8 = ByteBuffer.allocate(pixelFormat.bpp / 8);
                                byteBuffer8.put(byteBuffer2.array(), (n3 &= 0x7F) * pixelFormat.bpp / 8, pixelFormat.bpp / 8);
                                while (n2-- > 0) {
                                    byteBuffer7.put(byteBuffer8.array());
                                }
                            }
                        }
                    }
                    modifiablePixelBuffer.imageRect(pixelFormat, rect2, byteBuffer.array());
                }
                rect2.tl.x += 64;
            }
            rect2.tl.y += 64;
        }
        zlibInStream.flushUnderlying();
        zlibInStream.setUnderlying(null, 0);
    }

    private static enum PIXEL_T {
        U8,
        U16,
        U24A,
        U24B,
        U32;

    }
}

