/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.processor.normalization;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.neuralsearch.processor.explain.DocIdAtSearchShard;

class ScoreNormalizationUtil {
    @Generated
    private static final Logger log = LogManager.getLogger(ScoreNormalizationUtil.class);
    private static final String PARAM_NAME_WEIGHTS = "weights";
    private static final float DELTA_FOR_SCORE_ASSERTION = 0.01f;

    ScoreNormalizationUtil() {
    }

    public void validateParams(Map<String, Object> actualParams, Set<String> supportedParams) {
        if (Objects.isNull(actualParams) || actualParams.isEmpty()) {
            return;
        }
        Optional<String> optionalNotSupportedParam = actualParams.keySet().stream().filter(paramName -> !supportedParams.contains(paramName)).findFirst();
        if (optionalNotSupportedParam.isPresent()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "provided parameter for combination technique is not supported. supported parameters are [%s]", String.join((CharSequence)",", supportedParams)));
        }
        if (actualParams.keySet().stream().anyMatch(PARAM_NAME_WEIGHTS::equalsIgnoreCase) && !(actualParams.get(PARAM_NAME_WEIGHTS) instanceof List)) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "parameter [%s] must be a collection of numbers", PARAM_NAME_WEIGHTS));
        }
    }

    public static void setNormalizedScore(Map<DocIdAtSearchShard, List<Float>> normalizedScores, DocIdAtSearchShard docIdAtSearchShard, int subQueryIndex, int numberOfSubQueries, float normalizedScore) {
        List<Float> scores = normalizedScores.get(docIdAtSearchShard);
        if (Objects.isNull(scores)) {
            scores = new ArrayList<Float>(numberOfSubQueries);
            for (int i = 0; i < numberOfSubQueries; ++i) {
                scores.add(Float.valueOf(0.0f));
            }
            normalizedScores.put(docIdAtSearchShard, scores);
        }
        scores.set(subQueryIndex, Float.valueOf(normalizedScore));
    }

    public void validateParameters(Map<String, Object> actualParameters, Set<String> supportedParametersTopLevel, Map<String, Set<String>> supportedParametersNested) {
        if (Objects.isNull(actualParameters) || actualParameters.isEmpty()) {
            return;
        }
        boolean hasUnknownParameters = false;
        for (Map.Entry<String, Object> entry : actualParameters.entrySet()) {
            String paramName = entry.getKey();
            Object paramValue = entry.getValue();
            if (!supportedParametersTopLevel.contains(paramName)) {
                hasUnknownParameters = true;
                continue;
            }
            if (paramValue instanceof Map) {
                Map nestedParams = (Map)paramValue;
                this.validateNestedParameters(nestedParams, supportedParametersNested.get(paramName));
                continue;
            }
            if (paramValue instanceof List) {
                for (Object item : (List)paramValue) {
                    if (item instanceof Map) {
                        this.validateNestedParameters((Map)item, supportedParametersNested.get(paramName));
                        continue;
                    }
                    hasUnknownParameters = true;
                }
                continue;
            }
            if (supportedParametersNested.isEmpty()) continue;
            hasUnknownParameters = true;
        }
        if (hasUnknownParameters) {
            throw new IllegalArgumentException("unrecognized parameters in normalization technique");
        }
    }

    private void validateNestedParameters(Map<String, Object> parameters, Set<String> supportedNestedParams) {
        if (Objects.isNull(parameters) || parameters.isEmpty()) {
            return;
        }
        boolean hasUnknownParameters = false;
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            String paramName = entry.getKey();
            if (!Objects.nonNull(supportedNestedParams) || supportedNestedParams.contains(paramName)) continue;
            hasUnknownParameters = true;
            break;
        }
        if (hasUnknownParameters) {
            throw new IllegalArgumentException("unrecognized parameters in normalization technique");
        }
    }
}

