/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.4.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Writer series of image from a SimpleITK image.


The ImageSeriesWriter is for writing a 3D image as a series of 2D images. A list of names
for the series of 2D images must be provided, and an exception will be
generated if the number of file names does not match the size of the
image in the z-direction.

DICOM series cannot be written with this class, as an exception will
be generated. To write a DICOM series the individual slices must be
extracted, proper DICOM tags must be added to the dictionaries, then
written with the ImageFileWriter.


See:
 itk::simple::WriteImage for the procedural interface


C++ includes: sitkImageSeriesWriter.h
*/
public class ImageSeriesWriter extends ProcessObject {
  private transient long swigCPtr;

  protected ImageSeriesWriter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.ImageSeriesWriter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(ImageSeriesWriter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(ImageSeriesWriter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
itk::simple::ImageSeriesWriter::~ImageSeriesWriter() override
*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_ImageSeriesWriter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::ImageSeriesWriter::ImageSeriesWriter()
*/
public  ImageSeriesWriter() {
    this(SimpleITKJNI.new_ImageSeriesWriter(), true);
  }

  /**
std::string itk::simple::ImageSeriesWriter::ToString() const override

Print ourselves to string

*/
public  String toString() {
    return SimpleITKJNI.ImageSeriesWriter_toString(swigCPtr, this);
  }

  /**
virtual std::vector&lt;std::string&gt; itk::simple::ImageSeriesWriter::GetRegisteredImageIOs() const

Get a vector of the names of registered itk ImageIOs.

*/
public  VectorString getRegisteredImageIOs() {
    return new VectorString(SimpleITKJNI.ImageSeriesWriter_getRegisteredImageIOs(swigCPtr, this), true);
  }

  public void setImageIO(String imageio) {
    SimpleITKJNI.ImageSeriesWriter_setImageIO(swigCPtr, this, imageio);
  }

  public String getImageIO() {
    return SimpleITKJNI.ImageSeriesWriter_getImageIO(swigCPtr, this);
  }

  /**
virtual std::string itk::simple::ProcessObject::GetName() const =0

return user readable name for the filter

*/
public  String getName() {
    return SimpleITKJNI.ImageSeriesWriter_getName(swigCPtr, this);
  }

  public void setUseCompression(boolean UseCompression) {
    SimpleITKJNI.ImageSeriesWriter_setUseCompression(swigCPtr, this, UseCompression);
  }

  public boolean getUseCompression() {
    return SimpleITKJNI.ImageSeriesWriter_getUseCompression(swigCPtr, this);
  }

  public void useCompressionOn() {
    SimpleITKJNI.ImageSeriesWriter_useCompressionOn(swigCPtr, this);
  }

  public void useCompressionOff() {
    SimpleITKJNI.ImageSeriesWriter_useCompressionOff(swigCPtr, this);
  }

  public void setCompressionLevel(int arg0) {
    SimpleITKJNI.ImageSeriesWriter_setCompressionLevel(swigCPtr, this, arg0);
  }

  public int getCompressionLevel() {
    return SimpleITKJNI.ImageSeriesWriter_getCompressionLevel(swigCPtr, this);
  }

  public void setCompressor(String arg0) {
    SimpleITKJNI.ImageSeriesWriter_setCompressor(swigCPtr, this, arg0);
  }

  public String getCompressor() {
    return SimpleITKJNI.ImageSeriesWriter_getCompressor(swigCPtr, this);
  }

  public void setFileNames(VectorString fileNames) {
    SimpleITKJNI.ImageSeriesWriter_setFileNames(swigCPtr, this, VectorString.getCPtr(fileNames), fileNames);
  }

  public VectorString getFileNames() {
    return new VectorString(SimpleITKJNI.ImageSeriesWriter_getFileNames(swigCPtr, this), false);
  }

  /**
Self&amp; itk::simple::ImageSeriesWriter::Execute(const Image &amp;image, const std::vector&lt; PathType &gt;
&amp;inFileNames, bool useCompression, int compressionLevel)
*/
public  void execute(Image arg0) {
    SimpleITKJNI.ImageSeriesWriter_execute__SWIG_0(swigCPtr, this, Image.getCPtr(arg0), arg0);
  }

  /**
Self&amp; itk::simple::ImageSeriesWriter::Execute(const Image &amp;image, const std::vector&lt; PathType &gt;
&amp;inFileNames, bool useCompression, int compressionLevel)
*/
public  void execute(Image image, VectorString inFileNames, boolean useCompression, int compressionLevel) {
    SimpleITKJNI.ImageSeriesWriter_execute__SWIG_1(swigCPtr, this, Image.getCPtr(image), image, VectorString.getCPtr(inFileNames), inFileNames, useCompression, compressionLevel);
  }

}
