---
stage: Application Security Testing
group: Static Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: トリアージ
description: ステータスごとの脆弱性の分離。
---

トリアージは、脆弱性管理ライフサイクルの第2段階です（検出、トリアージ、分析、修正）。

トリアージは、各脆弱性を評価し、どれを今すぐに対処する必要があるか、どれがそれほど重要でないかを判断する継続的なプロセスです。高リスクの脆弱性は、中または低リスクの脅威から分離されています。すべての脆弱性を分析して修正することが可能または実現可能とは限りません。リスク評価フレームワークの一環として、トリアージは、リソースが最も効果的な場所に適用されるようにします。脆弱性のトリアージは頻繁に行うのが最善です。そうすることで、トリアージサイクルごとの脆弱性の数を少なく、管理しやすくすることができます。

トリアージフェーズの目的は、各脆弱性を確認または無視することです。確認された脆弱性は分析フェーズに進みますが、無視された脆弱性は進みません。

セキュリティダッシュボード、セキュリティインベントリ、および脆弱性レポートに含まれるデータを使用して、脆弱性のトリアージを効率的かつ効果的に行うことができます。

## スコープ {#scope}

トリアージフェーズのスコープには、まだ評価されていないすべての脆弱性が含まれます。

脆弱性レポートをフィルタリングして、トリアージが必要な脆弱性を特定します: 

- **状態**: トリアージが必要

## リスク評価 {#risk-analysis}

リスク評価フレームワークに従って脆弱性のトリアージを実施する必要があります。業界または地理的な場所によっては、フレームワークへのコンプライアンスが法律で義務付けられている場合があります。そうでない場合は、次のような信頼できるリスク評価フレームワークを使用する必要があります:  

- [SANS Institute脆弱性管理フレームワーク](https://www.sans.org/blog/the-vulnerability-assessment-framework/)
- [OWASP Threat and Safeguard Matrix（TaSM）](https://owasp.org/www-project-threat-and-safeguard-matrix/)

通常、脆弱性に費やす時間と労力は、そのリスクに比例する必要があります。たとえば、トリアージ戦略では、重大度と優先度の高い脆弱性のみを分析フェーズに進め、残りは無視するようにします。この決定は、脆弱性のリスクしきい値に従って行う必要があります。

脆弱性のトリアージ後、そのステータスを次のいずれかに変更する必要があります: 

- **確認済み**: この脆弱性をトリアージし、分析が必要であると判断しました。
- **やめる**: この脆弱性をトリアージし、分析しないことを決定しました。

脆弱性を無視する場合は、無視された理由を説明する簡単なコメントを入力する必要があります。無視された脆弱性は、その後のスキャンで検出されても無視されます。脆弱性レコードは永続的ですが、脆弱性のステータスはいつでも変更できます。

## トリアージ戦略 {#triage-strategies}

これらの戦略を試して、最も重要な脆弱性に最初に焦点を当ててください。

### 重大なリスクのある脆弱性を優先する {#prioritize-vulnerabilities-of-significant-risk}

脆弱性をそのリスクに応じて優先します。

- [脆弱性の優先順位付けCI/CDコンポーネント](../vulnerabilities/risk_assessment_data.md#vulnerability-prioritizer)を使用して、脆弱性の優先順位付けを支援します。たとえば、CISAの既知の悪用された脆弱性（KEV）カタログにある脆弱性は、悪用されていることがわかっているため、最高の優先度で分析および修正する必要があります。
- グループごとに、**セキュリティインベントリ**に移動して、保護する必要のあるアセットを視覚化し、セキュリティ対策状況を改善するために実行する必要のあるアクションを理解します。
- グループごとに、**セキュリティダッシュボード**に移動し、**プロジェクトのセキュリティ状態**パネルを表示します。これにより、プロジェクトが最も重大度の高い脆弱性によってグループ化されます。このグループ化を使用して、各プロジェクトの脆弱性のトリアージの優先順位を付けます。
- 最優先度の高いプロジェクト（たとえば、顧客にデプロイされたアプリケーション）で、脆弱性のトリアージの優先順位を付けます。
- プロジェクトごとに、脆弱性レポートを表示します。脆弱性を重大度別にグループ化し、クリティカルおよび高重大度のすべての脆弱性のステータスを「確認済み」に変更します。

### リスクの低い脆弱性を無視する {#dismiss-vulnerabilities-of-low-risk}

最も重要なものに焦点を当てるために、リスクの低い脆弱性を一括してトリアージします。

- 脆弱性は検出されることがありますが、後続のCI/CDパイプラインでは検出されませんでした。このインスタンスでは、脆弱性のアクティビティーは**検出されませんでした**とラベル付けされています。その重大度が**low**（低）または**info**（情報）の場合、これらの脆弱性を無視することを選択できます。フィルター**アクティビティーを使用します: 検出されませんでした**を脆弱性レポートで選択し、ステータスを**やめる**に変更します。[脆弱性管理ポリシー](../policies/vulnerability_management_policy.md)を使用すると、これも自動化できます。
- 識別子で脆弱性を無視します。脆弱性がアプリケーションレイヤー外のコントロールによって軽減される場合、それらを無視することを選択できます。**識別子**フィルターを脆弱性レポートで使用して選択し、ステータスを**やめる**に変更します。
