/*
 * Decompiled with CFR 0.152.
 */
package io.sf.jclf.text;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;

public final class TokenParser
implements Iterator<String> {
    private String l;
    private char[] sep;
    private char[] delim;
    private boolean last_token_found = false;
    private String next = null;
    private boolean ignore_consecutive_sep = false;
    private final boolean keepDelimiters;
    private char nextDelimiter = '\u0000';
    private static final String DEFAULT_SEPARATOR = ", ";
    private static final String DEFAULT_DELIMITER = "\"";
    private static final int SEPARATOR_SIZE = 1;
    private char last_separator = '\u0000';
    private char next_separator = '\u0000';
    private final int ll;
    int ncom = -1;
    private int i = -1;
    private int lastdelim;

    public TokenParser(String line) {
        this(line, DEFAULT_SEPARATOR);
    }

    public TokenParser(String line, String separator) {
        this(line, separator, DEFAULT_DELIMITER);
    }

    public TokenParser(String line, String separator, String delimiters) {
        this(line, separator, delimiters, false);
    }

    public TokenParser(String line, String separator, String delimiters, boolean keepDelimiters) {
        this(line, separator, delimiters.toCharArray(), keepDelimiters);
    }

    TokenParser(String line, String separator, char[] delimiters, boolean keepDelimiters) {
        this.l = line;
        this.keepDelimiters = keepDelimiters;
        if (separator == null || separator.length() == 0) {
            this.next = this.l;
            this.last_token_found = true;
            this.ll = 0;
            return;
        }
        this.sep = separator.toCharArray();
        this.checkSeparators();
        this.delim = delimiters;
        boolean bl = this.ignore_consecutive_sep = this.isSeparator(' ') || this.isSeparator('\t');
        if (this.l == null || this.l.length() == 0) {
            this.next = null;
            this.ll = 0;
            return;
        }
        this.ll = this.l.length();
        this.findNext();
    }

    private void checkSeparators() {
        for (int i = 0; i < this.sep.length; ++i) {
            if (this.sep[i] != '\u0000') continue;
            throw new IllegalArgumentException("Separator cannot contain \\0");
        }
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    public boolean hasMoreTokens() {
        return this.hasNext();
    }

    @Override
    public String next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        String last_next = this.next;
        this.last_separator = this.next_separator;
        this.findNext();
        return last_next;
    }

    public String nextToken() {
        return this.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private void findNext() {
        if (this.last_token_found) {
            this.next = null;
            return;
        }
        int j = this.i + 1;
        StringBuilder prebuf = new StringBuilder();
        while (++this.i < this.ll - 1) {
            if (this.isDelimiter(this.l.charAt(this.i))) {
                this.setNextDelimiter();
                if (this.i > j) {
                    prebuf.append(this.l.subSequence(j, this.i));
                }
                if (this.keepDelimiters) {
                    prebuf.append(this.l.subSequence(this.i, this.i + 1));
                }
                j = this.i + 1;
                do {
                    ++this.i;
                } while (!this.isNextDelimiter(this.l.charAt(this.i)) && this.i < this.ll - 1);
                if (this.i >= this.ll - 1) break;
                ++this.ncom;
                this.appendToToken(prebuf, this.i, j);
                j = this.i + 1;
                continue;
            }
            if (!this.isSeparator(this.l.charAt(this.i))) continue;
            ++this.ncom;
            if (prebuf.length() > 0) {
                prebuf.append(this.l.subSequence(j, this.i));
                this.next = prebuf.toString();
            } else {
                this.next = this.l.substring(j, this.i);
            }
            this.setNextSeparator(this.l.charAt(this.i));
            if (this.ignore_consecutive_sep) {
                for (j = this.i + 1; j < this.ll && this.isSeparator(this.l.charAt(j)); ++j) {
                    ++this.i;
                }
            }
            return;
        }
        ++this.ncom;
        if (this.i == this.ll) {
            this.last_token_found = true;
            return;
        }
        if (this.isDelimiter(this.l.charAt(this.ll - 1))) {
            this.i = this.ll - 2;
        }
        if (prebuf.length() > 0) {
            this.appendToToken(prebuf, this.i + 1, j);
            this.next = prebuf.toString();
        } else {
            this.next = this.l.substring(j, this.i + 1);
        }
        ++this.ncom;
        this.last_token_found = true;
    }

    private void appendToToken(StringBuilder prebuf, int i, int j) {
        if (this.keepDelimiters && i < this.ll) {
            ++i;
        }
        prebuf.append(this.l.subSequence(j, i));
    }

    private boolean isDelimiter(char c) {
        this.lastdelim = TokenParser.charInArray(this.l.charAt(this.i), this.delim);
        if (this.lastdelim >= 0) {
            return true;
        }
        if (c == this.nextDelimiter) {
            this.lastdelim = 0;
            return true;
        }
        return false;
    }

    private void setNextDelimiter() {
        this.nextDelimiter = this.delim[this.lastdelim];
        switch (this.nextDelimiter) {
            case '(': {
                this.nextDelimiter = (char)41;
                break;
            }
            case '[': {
                this.nextDelimiter = (char)93;
                break;
            }
            case '{': {
                this.nextDelimiter = (char)125;
            }
        }
    }

    private boolean isNextDelimiter(char c) {
        return c == this.nextDelimiter;
    }

    private boolean isSeparator(char c) {
        return TokenParser.charInArray(c, this.sep) >= 0;
    }

    private static int charInArray(char c, char[] ca) {
        for (int j = 0; j < ca.length; ++j) {
            if (c != ca[j]) continue;
            return j;
        }
        return -1;
    }

    private void setNextSeparator(char csep) {
        this.next_separator = csep;
    }

    public char getLastSeparator() {
        if (this.last_separator == '\u0000') {
            throw new IllegalStateException("Neeed to call next() before using this method");
        }
        return this.last_separator;
    }

    public char getNextSeparator() {
        if (this.next_separator == '\u0000') {
            throw new IllegalStateException("No separators in this text!");
        }
        return this.next_separator;
    }

    public boolean hasMultipleTokens() {
        return this.next_separator != '\u0000';
    }

    public static String[] tokenize(String l, String sep, char[] delim, int init_size) {
        if (l == null || l.equals("")) {
            return null;
        }
        if (sep == null || sep.equals("")) {
            String[] c = new String[]{l};
            return c;
        }
        LinkedList<String> tokenlist = new LinkedList<String>();
        TokenParser tp = new TokenParser(l, sep, delim, false);
        while (tp.hasNext()) {
            tokenlist.add(tp.next());
        }
        return tokenlist.toArray(new String[0]);
    }
}

