/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.bookmarks.mindmapmode.ui;

import java.awt.Container;
import java.awt.Toolkit;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import org.freeplane.features.bookmarks.mindmapmode.BookmarksController;
import org.freeplane.features.bookmarks.mindmapmode.NodeBookmark;
import org.freeplane.features.bookmarks.mindmapmode.ui.BookmarkButton;
import org.freeplane.features.bookmarks.mindmapmode.ui.BookmarkToolbar;
import org.freeplane.features.bookmarks.mindmapmode.ui.BookmarkTransferableFactory;
import org.freeplane.features.bookmarks.mindmapmode.ui.BookmarkTransferables;
import org.freeplane.features.bookmarks.mindmapmode.ui.DropExecutor;
import org.freeplane.features.clipboard.ClipboardAccessor;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.clipboard.MapClipboardController;
import org.freeplane.features.map.clipboard.MindMapNodesSelection;
import org.freeplane.features.map.mindmapmode.clipboard.MMapClipboardController;

class BookmarkClipboardHandler {
    private static final String PASTE_ACTION_KEY = "bookmarkPaste";
    private final BookmarksController bookmarksController;
    private final DropExecutor dropExecutor;

    BookmarkClipboardHandler(BookmarksController bookmarksController, DropExecutor dropExecutor) {
        this.bookmarksController = bookmarksController;
        this.dropExecutor = dropExecutor;
    }

    void setupToolbarClipboardActions(BookmarkToolbar toolbar) {
        InputMap inputMap = toolbar.getInputMap(0);
        ActionMap actionMap = toolbar.getActionMap();
        int menuShortcutKeyMask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        KeyStroke pasteKeyStroke = KeyStroke.getKeyStroke(86, menuShortcutKeyMask);
        inputMap.put(pasteKeyStroke, PASTE_ACTION_KEY);
        actionMap.put(PASTE_ACTION_KEY, new ToolbarPasteAction(toolbar));
    }

    void copyBookmark(BookmarkButton button) {
        Container parent = button.getParent();
        if (!(parent instanceof BookmarkToolbar)) {
            return;
        }
        BookmarkToolbar toolbar = (BookmarkToolbar)((Object)parent);
        NodeBookmark bookmark = button.getBookmark();
        int sourceIndex = toolbar.getComponentIndex(button);
        BookmarkTransferables.CombinedTransferable transferable = BookmarkTransferableFactory.createCombinedTransferable(bookmark, sourceIndex, 1);
        ClipboardAccessor.getInstance().setClipboardContents((Transferable)transferable);
    }

    void pasteBookmarkAtButton(BookmarkButton button) {
        Transferable clipboardContents = ClipboardAccessor.getInstance().getClipboardContents();
        if (clipboardContents == null) {
            return;
        }
        Container parent = button.getParent();
        if (!(parent instanceof BookmarkToolbar)) {
            return;
        }
        BookmarkToolbar toolbar = (BookmarkToolbar)((Object)parent);
        NodeBookmark targetBookmark = button.getBookmark();
        if (clipboardContents.isDataFlavorSupported(BookmarkTransferables.BOOKMARK_FLAVOR)) {
            this.handleBookmarkPaste(clipboardContents, targetBookmark, false, toolbar);
        } else if (clipboardContents.isDataFlavorSupported(MindMapNodesSelection.mindMapNodeObjectsFlavor)) {
            NodeModel targetNode = targetBookmark.getNode();
            ((MMapClipboardController)MapClipboardController.getController()).paste(clipboardContents, targetNode, NodeModel.Side.BOTTOM_OR_RIGHT);
        }
    }

    private void pasteBookmarkAtEnd(BookmarkToolbar toolbar) {
        Transferable clipboardContents = ClipboardAccessor.getInstance().getClipboardContents();
        if (clipboardContents == null) {
            return;
        }
        if (clipboardContents.isDataFlavorSupported(BookmarkTransferables.BOOKMARK_FLAVOR)) {
            this.handleBookmarkPasteAtEnd(clipboardContents, toolbar);
        } else if (clipboardContents.isDataFlavorSupported(MindMapNodesSelection.mindMapNodeObjectsFlavor)) {
            this.dropExecutor.createBookmarkFromNodeAtEnd(clipboardContents, toolbar);
        }
    }

    private void handleBookmarkPaste(Transferable transferable, NodeBookmark targetBookmark, boolean pasteAfter, BookmarkToolbar toolbar) {
        try {
            int sourceIndex = (Integer)transferable.getTransferData(BookmarkTransferables.BOOKMARK_FLAVOR);
            MapModel map = toolbar.getMap();
            int targetIndex = this.bookmarksController.findBookmarkPosition(this.bookmarksController.getBookmarks(map).getBookmarks(), targetBookmark);
            int insertionIndex = pasteAfter ? targetIndex + 1 : targetIndex;
            this.dropExecutor.moveBookmark(sourceIndex, insertionIndex);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void handleBookmarkPasteAtEnd(Transferable transferable, BookmarkToolbar toolbar) {
        try {
            int sourceIndex = (Integer)transferable.getTransferData(BookmarkTransferables.BOOKMARK_FLAVOR);
            MapModel map = toolbar.getMap();
            int insertionIndex = this.bookmarksController.getBookmarks(map).getBookmarks().size();
            this.dropExecutor.moveBookmark(sourceIndex, insertionIndex);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private class ToolbarPasteAction
    extends AbstractAction {
        private final BookmarkToolbar toolbar;

        ToolbarPasteAction(BookmarkToolbar toolbar) {
            this.toolbar = toolbar;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BookmarkClipboardHandler.this.pasteBookmarkAtEnd(this.toolbar);
        }
    }
}

