/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.map;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.freeplane.features.map.Clones;
import org.freeplane.features.map.DetachedNodeList;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.SingleNodeList;

public class MultipleNodeList
implements Clones {
    private final NodeModel.CloneType cloneType;
    LinkedList<NodeModel> nodes = new LinkedList();

    public MultipleNodeList(NodeModel.CloneType cloneType) {
        this.cloneType = cloneType;
    }

    @Override
    public Clones add(NodeModel nodeModel) {
        this.nodes.add(nodeModel);
        return this;
    }

    public Clones remove(NodeModel nodeModel) {
        this.nodes.remove(nodeModel);
        if (this.nodes.size() == 1) {
            return new SingleNodeList(this.head(), this.cloneType);
        }
        return this;
    }

    public Iterable<NodeModel> all() {
        return this.nodes;
    }

    @Override
    public Iterator<NodeModel> iterator() {
        return this.nodes.iterator();
    }

    @Override
    public int size() {
        return this.nodes.size();
    }

    @Override
    public void attach() {
        throw new IllegalStateException();
    }

    @Override
    public void detach(NodeModel nodeModel) {
        Clones reducedClones = this.remove(nodeModel);
        NodeModel head = this.head();
        nodeModel.setClones(new DetachedNodeList(nodeModel, head, this.cloneType));
        head.setClones(reducedClones);
    }

    @Override
    public Collection<NodeModel> toCollection() {
        return this.nodes;
    }

    @Override
    public boolean contains(NodeModel node) {
        if (node == null || !node.isAttached()) {
            return false;
        }
        return this.head().equals(node.clones(this.cloneType).head());
    }

    @Override
    public NodeModel head() {
        return this.nodes.get(0);
    }

    @Override
    public NodeModel.CloneType getCloneType() {
        return this.cloneType;
    }
}

